/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.network;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2540;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import su.plo.voice.client.VoiceClient;
import su.plo.voice.common.packets.Packet;
import su.plo.voice.common.packets.tcp.ClientConnectPacket;
import su.plo.voice.common.packets.tcp.ClientDisconnectedPacket;
import su.plo.voice.common.packets.tcp.ClientUnmutedPacket;
import su.plo.voice.common.packets.tcp.ConfigPacket;
import su.plo.voice.common.packets.tcp.PacketTCP;
import su.plo.voice.common.packets.tcp.ServerConnectPacket;
import su.plo.voice.server.PlayerManager;
import su.plo.voice.server.VoiceServer;
import su.plo.voice.server.config.ServerConfig;
import su.plo.voice.server.socket.SocketClientUDP;
import su.plo.voice.server.socket.SocketServerUDP;

public abstract class ServerNetworkHandler {
    public static Map<UUID, UUID> playerToken = new ConcurrentHashMap<UUID, UUID>();
    private static ScheduledExecutorService executor;

    public static void reconnectClient(class_3222 player) {
        ServerNetworkHandler.execute(() -> {
            ServerNetworkHandler.disconnectClient(player.method_5667());
            UUID token = UUID.randomUUID();
            playerToken.put(player.method_5667(), token);
            try {
                ServerNetworkHandler.sendTo(new ServerConnectPacket(token.toString(), VoiceServer.getServerConfig().getProxyIp() != null && !VoiceServer.getServerConfig().getProxyIp().isEmpty() ? VoiceServer.getServerConfig().getProxyIp() : VoiceServer.getServerConfig().getIp(), VoiceServer.getServerConfig().getProxyPort() != 0 ? VoiceServer.getServerConfig().getProxyPort() : VoiceServer.getServerConfig().getPort(), VoiceServer.getPlayerManager().hasPermission(player.method_5667(), "voice.priority")), player);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public static void disconnectClient(UUID uuid) {
        SocketClientUDP clientUDP = SocketServerUDP.clients.get(uuid);
        try {
            if (clientUDP != null) {
                clientUDP.close();
                ServerNetworkHandler.sendToClients(new ClientDisconnectedPacket(uuid), null);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void sendTo(Packet packet, class_3222 player) throws IOException {
        player.field_13987.method_14364((class_2596)new class_2658(VoiceServer.PLASMO_VOICE, new class_2540(Unpooled.wrappedBuffer((byte[])PacketTCP.write(packet)))));
    }

    public static void sendToClients(Packet packet, UUID except) {
        ServerNetworkHandler.execute(() -> {
            try {
                byte[] pkt = PacketTCP.write(packet);
                Enumeration<UUID> it = SocketServerUDP.clients.keys();
                while (it.hasMoreElements()) {
                    UUID uuid = it.nextElement();
                    if (uuid.equals(except)) continue;
                    class_3222 player = PlayerManager.getByUUID(uuid);
                    player.field_13987.method_14364((class_2596)new class_2658(VoiceServer.PLASMO_VOICE, new class_2540(Unpooled.wrappedBuffer((byte[])pkt))));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    protected static void execute(Runnable runnable) {
        if (executor == null || executor.isShutdown() || executor.isTerminated()) {
            return;
        }
        try {
            executor.submit(runnable);
        }
        catch (RejectedExecutionException e) {
            VoiceClient.LOGGER.warn("Failed to execute: {}", (Object)e.getMessage());
        }
    }

    protected static Optional<ScheduledFuture<?>> schedule(Runnable runnable, long delay, TimeUnit unit) {
        if (executor != null && !executor.isShutdown() && !executor.isTerminated()) {
            try {
                return Optional.of(executor.schedule(runnable, delay, unit));
            }
            catch (RejectedExecutionException e) {
                VoiceClient.LOGGER.warn("Failed to execute: {}", (Object)e.getMessage());
            }
        }
        return Optional.empty();
    }

    public boolean isVanillaPlayer(class_3222 player) {
        return true;
    }

    public void start() {
        executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleAtFixedRate(() -> VoiceServer.getMuted().forEach((uuid, muted) -> {
            if (muted.getTo() > 0L && muted.getTo() < System.currentTimeMillis()) {
                VoiceServer.getMuted().remove(uuid);
                VoiceServer.saveData(true);
                class_3222 player = PlayerManager.getByUUID(uuid);
                if (player != null) {
                    ServerNetworkHandler.sendToClients(new ClientUnmutedPacket((UUID)uuid), null);
                    player.method_43496((class_2561)class_2561.method_43470((String)VoiceServer.getInstance().getMessagePrefix("player_unmuted")));
                }
            }
        }), 0L, 5L, TimeUnit.SECONDS);
    }

    public void close() {
        executor.shutdown();
    }

    public void handleRegisterChannels(List<class_2960> channels, class_3222 player) {
        if (!playerToken.containsKey(player.method_5667()) && channels.contains(VoiceServer.PLASMO_VOICE) && !SocketServerUDP.clients.containsKey(player.method_5667())) {
            ServerNetworkHandler.reconnectClient(player);
        }
    }

    public void handleJoin(class_3222 player) {
        if (VoiceServer.getServer() == null) {
            return;
        }
        if (PlayerManager.isOp(player) && !SocketServerUDP.started) {
            player.method_43496((class_2561)class_2561.method_43470((String)(VoiceServer.getInstance().getPrefix() + String.format("Voice chat is installed but doesn't work. Check if port %d UDP is open.", VoiceServer.getServerConfig().getPort()))));
        }
    }

    public void handleQuit(class_3222 player) {
        playerToken.remove(player.method_5667());
        ServerNetworkHandler.execute(() -> ServerNetworkHandler.disconnectClient(player.method_5667()));
    }

    public void handle(ClientConnectPacket packet, class_3222 player) throws IOException {
        ServerConfig config = VoiceServer.getServerConfig();
        String version = packet.getVersion();
        int ver = VoiceServer.calculateVersion(version);
        if (ver > VoiceServer.version) {
            player.method_43496((class_2561)class_2561.method_43469((String)"message.plasmo_voice.version_not_supported", (Object[])new Object[]{"1.0.0"}));
            return;
        }
        if (ver < VoiceServer.minVersion) {
            player.method_43496((class_2561)class_2561.method_43469((String)"message.plasmo_voice.min_version", (Object[])new Object[]{"0.0.6"}));
            return;
        }
        if (ver < VoiceServer.version) {
            class_5250 link = class_2561.method_43470((String)"https://www.curseforge.com/minecraft/mc-mods/plasmo-voice-client/files");
            link.method_10862(link.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11749, "https://www.curseforge.com/minecraft/mc-mods/plasmo-voice-client/files")));
            player.method_43496((class_2561)class_2561.method_43469((String)"message.plasmo_voice.new_version_available", (Object[])new Object[]{"1.0.0", link}));
        }
        ServerNetworkHandler.sendTo(new ConfigPacket(config.getSampleRate(), new ArrayList<Integer>(config.getDistances()), config.getDefaultDistance(), config.getMaxPriorityDistance(), config.isDisableVoiceActivation() || !VoiceServer.getPlayerManager().hasPermission(player.method_5667(), "voice.activation"), config.getFadeDivisor(), config.getPriorityFadeDivisor()), player);
    }
}

