/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.common.packets.tcp;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import su.plo.voice.common.packets.Packet;
import su.plo.voice.common.packets.tcp.ClientConnectPacket;
import su.plo.voice.common.packets.tcp.ClientConnectedPacket;
import su.plo.voice.common.packets.tcp.ClientDisconnectedPacket;
import su.plo.voice.common.packets.tcp.ClientMutedPacket;
import su.plo.voice.common.packets.tcp.ClientUnmutedPacket;
import su.plo.voice.common.packets.tcp.ClientsListPacket;
import su.plo.voice.common.packets.tcp.ConfigPacket;
import su.plo.voice.common.packets.tcp.ServerConnectPacket;

public class PacketTCP {
    private static final Map<Integer, Class<? extends Packet>> packetRegistry = new HashMap<Integer, Class<? extends Packet>>();

    private static int getPacketType(Packet packet) {
        for (Map.Entry<Integer, Class<? extends Packet>> entry : packetRegistry.entrySet()) {
            if (!packet.getClass().equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return -1;
    }

    public static byte[] write(Packet packet) throws IOException {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeByte(PacketTCP.getPacketType(packet));
        packet.write(out);
        return out.toByteArray();
    }

    public static Packet read(ByteArrayDataInput buf) throws IllegalAccessException, InstantiationException, IOException, NoSuchMethodException, InvocationTargetException {
        byte packetType = buf.readByte();
        Class<? extends Packet> packetClass = packetRegistry.get(packetType);
        if (packetClass == null) {
            throw new InstantiationException("Could not find packet with ID " + packetType);
        }
        Packet packet = packetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        packet.read(buf);
        return packet;
    }

    static {
        packetRegistry.put(0, ClientsListPacket.class);
        packetRegistry.put(1, ClientMutedPacket.class);
        packetRegistry.put(2, ClientUnmutedPacket.class);
        packetRegistry.put(3, ClientConnectedPacket.class);
        packetRegistry.put(4, ClientDisconnectedPacket.class);
        packetRegistry.put(5, ConfigPacket.class);
        packetRegistry.put(6, ServerConnectPacket.class);
        packetRegistry.put(7, ClientConnectPacket.class);
    }
}

