/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.sound.capture;

import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import su.plo.voice.client.VoiceClient;
import su.plo.voice.client.sound.Recorder;
import su.plo.voice.client.sound.VolumeAdjuster;
import su.plo.voice.client.sound.capture.CaptureDevice;

public class JavaxCaptureDevice
implements CaptureDevice {
    private TargetDataLine device;
    private final VolumeAdjuster adjuster = new VolumeAdjuster();

    @Override
    public void open() throws IllegalStateException {
        if (this.isOpen()) {
            throw new IllegalStateException("Capture device already open");
        }
        this.device = JavaxCaptureDevice.get();
        if (this.device == null) {
            this.device = JavaxCaptureDevice.getDefault();
            if (this.device == null) {
                throw new IllegalStateException("Failed to open javax capture device");
            }
        }
        try {
            this.device.open(Recorder.getFormat());
        }
        catch (LineUnavailableException e) {
            throw new IllegalStateException(e.getMessage());
        }
        this.device.start();
        this.device.stop();
        this.device.flush();
    }

    @Override
    public void start() {
        if (!this.isOpen()) {
            return;
        }
        this.device.start();
    }

    @Override
    public void stop() {
        if (!this.isOpen()) {
            return;
        }
        this.device.stop();
        this.device.flush();
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.device.stop();
        this.device.flush();
        this.device.close();
    }

    public int available() {
        return 0;
    }

    @Override
    public byte[] read(int frameSize) {
        byte[] buffer = new byte[frameSize];
        int read = this.device.read(buffer, 0, frameSize);
        if (read == -1) {
            return null;
        }
        this.adjuster.adjust(buffer, ((Double)VoiceClient.getClientConfig().microphoneAmplification.get()).floatValue());
        return buffer;
    }

    @Override
    public boolean isOpen() {
        return this.device != null && this.device.isOpen();
    }

    private static TargetDataLine get() {
        TargetDataLine mic;
        String micName = (String)VoiceClient.getClientConfig().microphone.get();
        if (micName != null && (mic = JavaxCaptureDevice.getByName(micName)) != null) {
            return mic;
        }
        return JavaxCaptureDevice.getDefault();
    }

    public static List<String> getNames() {
        Mixer.Info[] mixers;
        ArrayList<String> names = new ArrayList<String>();
        for (Mixer.Info mixerInfo : mixers = AudioSystem.getMixerInfo()) {
            Line.Info lineInfo;
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            if (!mixer.isLineSupported(lineInfo = new Line.Info(TargetDataLine.class))) continue;
            names.add(mixerInfo.getName());
        }
        return names;
    }

    private static TargetDataLine getByName(String name) {
        Mixer.Info[] mixers;
        for (Mixer.Info mixerInfo : mixers = AudioSystem.getMixerInfo()) {
            String deviceName;
            Line.Info lineInfo;
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            if (!mixer.isLineSupported(lineInfo = new Line.Info(TargetDataLine.class)) || !(deviceName = mixerInfo.getName()).equals(name)) continue;
            try {
                return (TargetDataLine)mixer.getLine(lineInfo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static TargetDataLine getDefault() {
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, null);
        try {
            return (TargetDataLine)AudioSystem.getLine(info);
        }
        catch (Exception e) {
            return null;
        }
    }
}

