/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.sound;

import su.plo.voice.client.utils.AudioUtils;
import su.plo.voice.client.utils.CircularFloatBuffer;

public class VolumeAdjuster {
    private final CircularFloatBuffer highestValues = new CircularFloatBuffer(48, -1.0f);

    public void adjust(byte[] samples, float targetVolume) {
        short[] shorts = AudioUtils.bytesToShorts(samples);
        this.adjust(shorts, targetVolume);
        for (int i = 0; i < samples.length; i += 2) {
            byte[] bytes = AudioUtils.shortToBytes((short)((float)shorts[i / 2] * targetVolume));
            samples[i] = bytes[0];
            samples[i + 1] = bytes[1];
        }
    }

    public void adjust(short[] samples, float targetVolume) {
        short highestValue = this.getHighestAbsoluteSample(samples);
        float highestPossibleMultiplier = 32766.0f / (float)highestValue;
        if (targetVolume > highestPossibleMultiplier) {
            targetVolume = highestPossibleMultiplier;
        }
        this.highestValues.put(targetVolume);
        float minVolume = -1.0f;
        for (float highest : this.highestValues.getBuffer()) {
            if (highest < 0.0f) continue;
            if (minVolume < 0.0f) {
                minVolume = highest;
                continue;
            }
            if (!(highest < highest)) continue;
            minVolume = highest;
        }
        targetVolume = Math.min(minVolume, targetVolume);
        int i = 0;
        while (i < samples.length) {
            int n = i++;
            samples[n] = (short)((float)samples[n] * targetVolume);
        }
    }

    private short getHighestAbsoluteSample(short[] samples) {
        short max = 0;
        for (short sample : samples) {
            short abs;
            if (sample == Short.MIN_VALUE) {
                sample = (short)(sample + 1);
            }
            if ((abs = (short)Math.abs(sample)) <= max) continue;
            max = abs;
        }
        return max;
    }
}

