/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.sound;

import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.class_310;
import su.plo.voice.client.socket.SocketClientUDPQueue;
import su.plo.voice.client.sound.Compressor;
import su.plo.voice.client.sound.Recorder;
import su.plo.voice.client.sound.openal.CustomSource;
import su.plo.voice.client.sound.opus.OpusDecoder;
import su.plo.voice.common.packets.udp.VoiceServerPacket;

public abstract class AbstractSoundQueue
extends Thread {
    public CustomSource source;
    protected final class_310 minecraft = class_310.method_1551();
    public BlockingQueue<VoiceServerPacket> queue = new LinkedBlockingQueue<VoiceServerPacket>();
    protected boolean stopped;
    protected long lastPacketTime;
    public final UUID from;
    public long lastSequenceNumber;
    protected OpusDecoder opusDecoder;
    protected double lastOcclusion = -1.0;
    protected final Compressor compressor = new Compressor();

    public AbstractSoundQueue(UUID from) {
        this.from = from;
        this.lastPacketTime = System.currentTimeMillis() - 300L;
        this.lastSequenceNumber = -1L;
        this.opusDecoder = new OpusDecoder(Recorder.getSampleRate(), Recorder.getFrameSize(), Recorder.getMtuSize());
    }

    public boolean canKill() {
        return System.currentTimeMillis() - this.lastPacketTime > 30000L;
    }

    public void closeAndKill() {
        this.stopped = true;
        SocketClientUDPQueue.talking.remove(this.from);
        this.opusDecoder.close();
    }

    public boolean isClosed() {
        return this.stopped;
    }

    public void addQueue(VoiceServerPacket packet) {
        if (packet == null) {
            return;
        }
        this.queue.add(packet);
    }
}

