/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.network;

import io.netty.buffer.Unpooled;
import io.netty.channel.local.LocalAddress;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_746;
import su.plo.voice.client.VoiceClient;
import su.plo.voice.client.config.ServerSettings;
import su.plo.voice.client.gui.VoiceNotAvailableScreen;
import su.plo.voice.client.socket.SocketClientUDP;
import su.plo.voice.client.socket.SocketClientUDPQueue;
import su.plo.voice.client.sound.AbstractSoundQueue;
import su.plo.voice.common.entities.MutedEntity;
import su.plo.voice.common.packets.Packet;
import su.plo.voice.common.packets.tcp.ClientConnectPacket;
import su.plo.voice.common.packets.tcp.ClientConnectedPacket;
import su.plo.voice.common.packets.tcp.ClientDisconnectedPacket;
import su.plo.voice.common.packets.tcp.ClientMutedPacket;
import su.plo.voice.common.packets.tcp.ClientUnmutedPacket;
import su.plo.voice.common.packets.tcp.ClientsListPacket;
import su.plo.voice.common.packets.tcp.ConfigPacket;
import su.plo.voice.common.packets.tcp.PacketTCP;
import su.plo.voice.common.packets.tcp.ServerConnectPacket;

public abstract class ClientNetworkHandler {
    private final class_310 client = class_310.method_1551();

    public void reply(class_2535 connection, Packet packet) throws IOException {
        connection.method_10743((class_2596)new class_2817(VoiceClient.PLASMO_VOICE, new class_2540(Unpooled.wrappedBuffer((byte[])PacketTCP.write(packet)))));
    }

    public void handle(ServerConnectPacket packet, class_2535 connection) throws IOException {
        VoiceClient.disconnect();
        VoiceClient.socketUDP = null;
        if (!(connection.method_10755() instanceof InetSocketAddress) && !(connection.method_10755() instanceof LocalAddress)) {
            return;
        }
        String ip = packet.getIp();
        String serverIp = "127.0.0.1";
        if (ip.equals("0.0.0.0")) {
            if (connection.method_10755() instanceof InetSocketAddress) {
                InetSocketAddress addr = (InetSocketAddress)connection.method_10755();
                Inet4Address in4addr = (Inet4Address)addr.getAddress();
                String[] ipSplit = in4addr.toString().split("/");
                serverIp = ipSplit[0];
                if (ipSplit.length > 1) {
                    serverIp = ipSplit[1];
                }
            }
            ip = serverIp;
        }
        VoiceClient.LOGGER.info("Connecting to " + (this.client.method_1558() == null ? "localhost" : this.client.method_1558().field_3761));
        VoiceClient.setServerConfig(new ServerSettings(packet.getToken(), ip, packet.getPort(), packet.hasPriority()));
        VoiceClient.getSoundEngine().start();
        this.reply(connection, new ClientConnectPacket(packet.getToken(), "1.0.0"));
    }

    public void handle(ConfigPacket packet) throws IOException {
        if (VoiceClient.getServerConfig() != null) {
            VoiceClient.getServerConfig().update(packet);
            if (!VoiceClient.isConnected()) {
                VoiceClient.socketUDP = new SocketClientUDP();
                VoiceClient.socketUDP.start();
                class_437 class_4372 = this.client.field_1755;
                if (class_4372 instanceof VoiceNotAvailableScreen) {
                    VoiceNotAvailableScreen screen = (VoiceNotAvailableScreen)class_4372;
                    screen.setConnecting();
                }
            }
        }
    }

    public void handle(ClientMutedPacket packet) {
        if (VoiceClient.getServerConfig() != null) {
            VoiceClient.getServerConfig().getMuted().put(packet.getClient(), new MutedEntity(packet.getClient(), packet.getTo()));
            AbstractSoundQueue queue = SocketClientUDPQueue.audioChannels.get(packet.getClient());
            if (queue != null) {
                queue.closeAndKill();
                SocketClientUDPQueue.audioChannels.remove(packet.getClient());
            }
            VoiceClient.LOGGER.info(packet.getClient().toString() + " muted");
        }
    }

    public void handle(ClientUnmutedPacket packet) {
        if (VoiceClient.getServerConfig() != null) {
            VoiceClient.getServerConfig().getMuted().remove(packet.getClient());
            VoiceClient.LOGGER.info(packet.getClient().toString() + " unmuted");
        }
    }

    public void handle(ClientsListPacket packet) {
        if (VoiceClient.getServerConfig() != null) {
            VoiceClient.getServerConfig().getMuted().clear();
            VoiceClient.getServerConfig().getClients().clear();
            ArrayList<String> mutedList = new ArrayList<String>();
            for (MutedEntity muted : packet.getMuted()) {
                mutedList.add(muted.uuid.toString());
                VoiceClient.getServerConfig().getMuted().put(muted.uuid, muted);
            }
            VoiceClient.getServerConfig().getClients().addAll(packet.getClients());
            VoiceClient.LOGGER.info("Clients: " + packet.getClients().toString());
            VoiceClient.LOGGER.info("Muted clients: " + mutedList);
        }
    }

    public void handle(ClientConnectedPacket packet) {
        if (VoiceClient.getServerConfig() != null) {
            if (packet.getMuted() != null) {
                MutedEntity muted = packet.getMuted();
                VoiceClient.getServerConfig().getMuted().put(muted.uuid, muted);
            }
            VoiceClient.getServerConfig().getClients().add(packet.getClient());
        }
    }

    public void handle(ClientDisconnectedPacket packet) {
        if (VoiceClient.getServerConfig() != null) {
            VoiceClient.getServerConfig().getClients().remove(packet.getClient());
            VoiceClient.getServerConfig().getMuted().remove(packet.getClient());
            class_746 player = class_310.method_1551().field_1724;
            if (player != null && packet.getClient().equals(player.method_5667())) {
                VoiceClient.disconnect();
            }
        }
    }
}

