/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.widgets;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import su.plo.voice.client.VoiceClient;
import su.plo.voice.client.gui.VoiceSettingsScreen;
import su.plo.voice.client.gui.widgets.BackgroundImageButton;
import su.plo.voice.client.sound.openal.CustomSource;

public class MicrophoneThresholdWidget
extends class_357 {
    private final VoiceSettingsScreen parent;
    private final class_310 client = class_310.method_1551();
    private final boolean slider;
    private List<BackgroundImageButton> microphoneTest;

    public MicrophoneThresholdWidget(int x, int y, int width, boolean slider, VoiceSettingsScreen parent) {
        super(x, y, width - 23, 20, (class_2561)class_2561.method_43473(), 0.0);
        this.slider = slider;
        this.updateValue();
        BackgroundImageButton speakerHide = new BackgroundImageButton(0, 0, 20, 20, 0, 72, 20, VoiceClient.ICONS, 256, 256, button -> this.closeSpeaker());
        BackgroundImageButton speakerShow = new BackgroundImageButton(0, 0, 20, 20, 20, 72, 20, VoiceClient.ICONS, 256, 256, button -> {
            this.microphoneTest.get((int)0).field_22764 = true;
            this.microphoneTest.get((int)1).field_22764 = false;
            VoiceClient.getSoundEngine().runInContext(() -> {
                CustomSource source = VoiceClient.getSoundEngine().createSource();
                source.setRelative(true);
                source.setPosition(new class_243(0.0, 0.0, 0.0));
                parent.setSource(source);
            });
        });
        speakerHide.field_22764 = false;
        speakerShow.field_22763 = VoiceClient.recorder.isAvailable();
        this.parent = parent;
        this.microphoneTest = ImmutableList.of((Object)((Object)speakerHide), (Object)((Object)speakerShow));
    }

    public void closeSpeaker() {
        this.microphoneTest.get((int)0).field_22764 = false;
        this.microphoneTest.get((int)1).field_22764 = true;
        if (this.parent.getSource() != null) {
            VoiceClient.getSoundEngine().runInContext(() -> {
                this.parent.getSource().close();
                this.parent.setSource(null);
            });
        }
    }

    public void updateValue() {
        this.field_22753 = 1.0 - Math.max(-60.0, (Double)VoiceClient.getClientConfig().voiceActivationThreshold.get()) / -60.0;
        this.method_25346();
    }

    protected void method_25346() {
        this.method_25355((class_2561)class_2561.method_43470((String)(Math.round((1.0 - this.field_22753) * -60.0) + " dB")));
    }

    protected void method_25344() {
        VoiceClient.getClientConfig().voiceActivationThreshold.set(Double.valueOf(Math.round((1.0 - this.field_22753) * -60.0)));
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return this.slider && super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.slider && super.method_25402(mouseX, mouseY, button) || this.microphoneTest.get(0).method_25402(mouseX, mouseY, button) || this.microphoneTest.get(1).method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (mouseX >= (double)this.field_22760 && mouseX <= (double)(this.field_22760 + this.field_22758) && this.slider) {
            return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        return false;
    }

    public boolean method_25367() {
        return super.method_25367() && this.field_22763;
    }

    public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
        class_327 textRenderer = this.client.field_1772;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)field_22757);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
        int i = this.method_25356(this.method_25367());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        this.method_25302(matrices, this.field_22760, this.field_22761, 0, 46 + i * 20, this.field_22758 / 2, this.field_22759);
        this.method_25302(matrices, this.field_22760 + this.field_22758 / 2, this.field_22761, 200 - this.field_22758 / 2, 46 + i * 20, this.field_22758 / 2, this.field_22759);
        if (this.parent.getMicrophoneValue() > 0.95) {
            RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)this.field_22765);
        } else if (this.parent.getMicrophoneValue() > 0.7) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)0.0f, (float)this.field_22765);
        } else {
            RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)0.0f, (float)this.field_22765);
        }
        this.method_25302(matrices, this.field_22760 + 1, this.field_22761 + 1, 1, 47, (int)((double)(this.field_22758 - 2) * this.parent.getMicrophoneValue()), this.field_22759 - 2);
        if (this.slider) {
            this.method_25353(matrices, this.client, mouseX, mouseY);
            int j = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
            MicrophoneThresholdWidget.method_27534((class_4587)matrices, (class_327)textRenderer, (class_2561)this.method_25369(), (int)(this.field_22760 + this.field_22758 / 2), (int)(this.field_22761 + (this.field_22759 - 8) / 2), (int)(j | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24));
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
        for (BackgroundImageButton button : this.microphoneTest) {
            button.field_22760 = this.field_22760 + this.field_22758 + 2;
            button.field_22761 = this.field_22761;
            button.method_25394(matrices, mouseX, mouseY, delta);
            if (VoiceClient.recorder.isAvailable() || !button.isHovered(false)) continue;
            this.parent.setTooltip((List<class_2561>)ImmutableList.of((Object)class_2561.method_43471((String)"gui.plasmo_voice.general.not_available")));
        }
    }
}

