/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.util;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;

public class MixinUtils {
    private static final List<MixinInfo> MIXINS;

    private static List<IMixinConfig> goFish() throws ReflectiveOperationException {
        Object transformer = MixinEnvironment.getCurrentEnvironment().getActiveTransformer();
        if (transformer == null) {
            throw new IllegalStateException("No active transformer?");
        }
        Object processor = FieldUtils.readDeclaredField((Object)transformer, (String)"processor", (boolean)true);
        assert (processor != null);
        Object configs = FieldUtils.readDeclaredField((Object)processor, (String)"configs", (boolean)true);
        assert (configs != null);
        return (List)configs;
    }

    public static List<Mixin> getMixinsFor(String target) {
        return MIXINS.stream().filter(info -> info.hasMixinFor(target)).flatMap(info -> info.getMixinsFor(target).stream()).map(Mixin::new).sorted().collect(Collectors.toList());
    }

    public static void completeClassInfo(ClassInfo info, Iterable<MethodNode> methods) {
        Set known = info.getMethods().stream().map(method -> method.getName().concat(method.getDesc())).collect(Collectors.toSet());
        ArrayList<ClassInfo.Method> extra = new ArrayList<ClassInfo.Method>();
        for (MethodNode method2 : methods) {
            if (known.contains(method2.name.concat(method2.desc)) || method2.name.charAt(0) == '<') continue;
            ClassInfo classInfo = info;
            classInfo.getClass();
            extra.add(new ClassInfo.Method(classInfo, method2));
        }
        if (!extra.isEmpty()) {
            try {
                Set allMethods = (Set)FieldUtils.readDeclaredField((Object)info, (String)"methods", (boolean)true);
                allMethods.addAll(extra);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Unable to add extra " + extra.size() + " methods to " + info + "'s class info", e);
            }
        }
    }

    static {
        try {
            MIXINS = Lists.transform(MixinUtils.goFish(), MixinInfo::new);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Error fishing for mixins", e);
        }
    }

    public static class Mixin
    implements Comparable<Mixin> {
        private final IMixinInfo mixin;
        private final ClassInfo info;
        private ClassNode node;

        public static Mixin create(IMixinInfo mixin) {
            return new Mixin(mixin);
        }

        Mixin(IMixinInfo mixin) {
            this.mixin = mixin;
            this.info = Mixin.getInfo(mixin);
            assert (this.info.isMixin());
        }

        private static ClassInfo getInfo(IMixinInfo mixin) {
            ClassInfo out = ClassInfo.fromCache((String)mixin.getClassName());
            if (out != null) {
                return out;
            }
            try {
                return (ClassInfo)FieldUtils.readDeclaredField((Object)mixin, (String)"info", (boolean)true);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Error getting class info from " + mixin, e);
            }
        }

        public String getName() {
            return this.mixin.getClassRef();
        }

        public ClassNode getClassNode() {
            if (this.node == null) {
                this.node = this.mixin.getClassNode(1);
            }
            return this.node;
        }

        public Set<ClassInfo.Method> getMethods() {
            return this.info.getMethods();
        }

        public boolean hasMethod(String name, String descriptor) {
            return this.getMethod(name, descriptor) != null;
        }

        public ClassInfo.Method getMethod(String name, String descriptor) {
            return this.info.findMethod(name, descriptor, 262154);
        }

        @Override
        public int compareTo(Mixin other) {
            return ((Comparable)this.mixin).compareTo(other.mixin);
        }

        public String toString() {
            return this.getName();
        }
    }

    public static class MixinInfo {
        private final IMixinConfig config;
        private final Method getMixins;

        MixinInfo(IMixinConfig config) {
            this.config = config;
            this.getMixins = MethodUtils.getMatchingMethod(config.getClass(), (String)"getMixinsFor", (Class[])new Class[]{String.class});
            this.getMixins.setAccessible(true);
        }

        public boolean hasMixinFor(String target) {
            return this.config.getTargets().contains(target);
        }

        public List<IMixinInfo> getMixinsFor(String target) {
            if (this.hasMixinFor(target)) {
                try {
                    return (List)this.getMixins.invoke((Object)this.config, target);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException("Error getting " + target + " mixins from " + this.config, e);
                }
            }
            return Collections.emptyList();
        }

        public String toString() {
            return this.config.getName();
        }
    }
}

