/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.patcher.fixes;

import com.google.common.collect.MoreCollectors;
import me.modmuss50.optifabric.patcher.fixes.ClassFixer;
import me.modmuss50.optifabric.util.RemappingUtils;
import org.apache.commons.lang3.Validate;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class KeyboardFix
implements ClassFixer {
    private final String onKeyName = RemappingUtils.getMethodName("class_309", "method_1466", "(JIIII)V");

    @Override
    public void fix(ClassNode optifine, ClassNode minecraft) {
        Validate.notNull((Object)this.onKeyName, (String)"onKeyName null", (Object[])new Object[0]);
        optifine.methods.removeIf(methodNode -> methodNode.name.equals(this.onKeyName));
        MethodNode methodNode2 = (MethodNode)minecraft.methods.stream().filter(node -> node.name.equals(this.onKeyName)).collect(MoreCollectors.onlyElement());
        Validate.notNull((Object)methodNode2, (String)"old method null", (Object[])new Object[0]);
        MethodNode lambdaNode = (MethodNode)minecraft.methods.stream().filter(node -> "method_1454".equals(node.name)).collect(MoreCollectors.onlyElement());
        Validate.notNull((Object)lambdaNode, (String)"old method lambda null", (Object[])new Object[0]);
        optifine.methods.add(methodNode2);
        optifine.methods.add(lambdaNode);
        String targetDescC = RemappingUtils.mapMethodDescriptor("(Lnet/minecraft/class_437;CI)V");
        String targetDescI = RemappingUtils.mapMethodDescriptor("(Lnet/minecraft/class_437;II)V");
        for (MethodNode method : optifine.methods) {
            if ((method.access | 8 | 0x1000) == method.access && (method.desc.equals(targetDescC) || method.desc.equals(targetDescI))) {
                method.desc = method.desc.replace("L" + RemappingUtils.getClassName("class_437") + ";", "L" + RemappingUtils.getClassName("class_364") + ";");
                for (AbstractInsnNode ain : method.instructions.toArray()) {
                    if (ain.getOpcode() != 25 || ((VarInsnNode)ain).var != 0) continue;
                    method.instructions.insert(ain, (AbstractInsnNode)new TypeInsnNode(192, RemappingUtils.getClassName("class_437")));
                }
                continue;
            }
            for (AbstractInsnNode ain : method.instructions.toArray()) {
                Handle handle;
                if (ain.getOpcode() != 186) continue;
                InvokeDynamicInsnNode idin = (InvokeDynamicInsnNode)ain;
                if (idin.bsmArgs.length != 3 || !(idin.bsmArgs[1] instanceof Handle) || (handle = (Handle)idin.bsmArgs[1]).getTag() != 6 || !handle.getOwner().equals(RemappingUtils.getClassName("class_309")) || !handle.getDesc().equals(targetDescC) && !handle.getDesc().equals(targetDescI)) continue;
                idin.desc = idin.desc.replace("L" + RemappingUtils.getClassName("class_437") + ";", "L" + RemappingUtils.getClassName("class_364") + ";");
                idin.bsmArgs[1] = new Handle(handle.getTag(), handle.getOwner(), handle.getName(), handle.getDesc().replace("L" + RemappingUtils.getClassName("class_437") + ";", "L" + RemappingUtils.getClassName("class_364") + ";"), handle.isInterface());
            }
        }
    }
}

