/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.highlighter;

import com.anthonyhilyard.highlighter.HighlighterConfig;
import com.anthonyhilyard.iceberg.events.NewItemPickupEvent;
import com.anthonyhilyard.iceberg.util.Easing;
import com.anthonyhilyard.iceberg.util.ItemColor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class Highlighter {
    public static final ResourceLocation NEW_ITEM_MARKS = new ResourceLocation("highlighter", "textures/gui/newitemmarks.png");
    private static Set<Integer> markedSlots = new HashSet<Integer>(36);

    @SubscribeEvent
    public static void preItemPickup(EntityItemPickupEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        Player player = event.getEntity();
        ItemStack item = event.getItem().m_32055_();
        if (player != null && player.equals((Object)mc.f_91074_)) {
            Highlighter.handlePreItemPickup(player, item);
        }
    }

    @SubscribeEvent
    public static void newItemPickup(NewItemPickupEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        Player player = event.getEntity();
        ItemStack item = event.getItemStack();
        if (player != null && player.equals((Object)mc.f_91074_)) {
            Highlighter.handlePreItemPickup(player, item);
        }
    }

    private static void handlePreItemPickup(Player player, ItemStack item) {
        int slot = player.m_150109_().m_36050_(item);
        if (slot == -1) {
            slot = player.m_150109_().m_36062_();
        }
        if (slot != -1) {
            markedSlots.add(slot);
        }
    }

    public static void itemClicked(int slotIndex) {
        markedSlots.remove(slotIndex);
    }

    public static void inventoryClosed() {
        if (((Boolean)HighlighterConfig.INSTANCE.clearOnInventoryClose.get()).booleanValue()) {
            markedSlots.clear();
        }
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        if (((Boolean)HighlighterConfig.INSTANCE.clearOnHover.get()).booleanValue()) {
            AbstractContainerScreen invScreen;
            Slot slot;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91080_ != null && mc.f_91080_ instanceof AbstractContainerScreen && (slot = (invScreen = (AbstractContainerScreen)mc.f_91080_).getSlotUnderMouse()) != null && slot.m_7993_() == event.getItemStack()) {
                markedSlots.remove(slot.getSlotIndex());
            }
        }
    }

    public static void renderNewItemMark(PoseStack poseStack, Slot slot) {
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.f_91074_.m_7500_()) {
            if (markedSlots.contains(slot.getSlotIndex()) && slot.m_6657_()) {
                Highlighter.render(poseStack, slot.m_7993_(), slot.f_40220_, slot.f_40221_);
            } else {
                markedSlots.remove(slot.getSlotIndex());
            }
        }
    }

    public static void renderHotBarItemMark(int slotIndex, PoseStack poseStack, ItemStack item, int x, int y) {
        if (!((Boolean)HighlighterConfig.INSTANCE.showOnHotbar.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.f_91074_.m_7500_() && markedSlots.contains(slotIndex)) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, -100.0);
            Highlighter.render(poseStack, item, x, y);
            poseStack.m_85849_();
        }
    }

    private static void render(PoseStack poseStack, ItemStack item, int x, int y) {
        if (item.m_41619_()) {
            return;
        }
        float timeOffset = Math.abs((float)(Util.m_137550_() % 2000L) / 1000.0f - 1.0f);
        TextColor color = TextColor.m_131270_((ChatFormatting)ChatFormatting.WHITE);
        if (((Boolean)HighlighterConfig.INSTANCE.useItemNameColor.get()).booleanValue()) {
            color = ItemColor.getColorForItem((ItemStack)item, (TextColor)color);
        }
        RenderSystem.m_69465_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)(-Easing.Ease((float)0.0f, (float)1.0f, (float)timeOffset)), 390.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)NEW_ITEM_MARKS);
        RenderSystem.m_157429_((float)((float)(color.m_131265_() >> 16 & 0xFF) / 255.0f), (float)((float)(color.m_131265_() >> 8 & 0xFF) / 255.0f), (float)((float)(color.m_131265_() & 0xFF) / 255.0f), (float)1.0f);
        Gui.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)((Boolean)HighlighterConfig.INSTANCE.useItemNameColor.get() != false ? 8.0f : 0.0f), (float)0.0f, (int)8, (int)8, (int)16, (int)16);
        poseStack.m_85849_();
    }
}

