/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl.api;

import com.google.common.collect.ImmutableList;
import dev.isxander.yacl.api.Option;
import dev.isxander.yacl.api.OptionGroup;
import dev.isxander.yacl.impl.ConfigCategoryImpl;
import dev.isxander.yacl.impl.OptionGroupImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public interface ConfigCategory {
    @NotNull
    public class_2561 name();

    @NotNull
    public ImmutableList<OptionGroup> groups();

    @NotNull
    public class_2561 tooltip();

    public static Builder createBuilder() {
        return new Builder();
    }

    public static class Builder {
        private class_2561 name;
        private final List<Option<?>> rootOptions = new ArrayList();
        private final List<OptionGroup> groups = new ArrayList<OptionGroup>();
        private final List<class_2561> tooltipLines = new ArrayList<class_2561>();

        private Builder() {
        }

        public Builder name(@NotNull class_2561 name) {
            Validate.notNull((Object)name, (String)"`name` cannot be null", (Object[])new Object[0]);
            this.name = name;
            return this;
        }

        public Builder option(@NotNull Option<?> option) {
            Validate.notNull(option, (String)"`option` must not be null", (Object[])new Object[0]);
            this.rootOptions.add(option);
            return this;
        }

        public Builder options(@NotNull Collection<Option<?>> options) {
            Validate.notNull(options, (String)"`options` must not be null", (Object[])new Object[0]);
            this.rootOptions.addAll(options);
            return this;
        }

        public Builder group(@NotNull OptionGroup group) {
            Validate.notNull((Object)group, (String)"`group` must not be null", (Object[])new Object[0]);
            this.groups.add(group);
            return this;
        }

        public Builder groups(@NotNull Collection<OptionGroup> groups) {
            Validate.notEmpty(groups, (String)"`groups` must not be empty", (Object[])new Object[0]);
            this.groups.addAll(groups);
            return this;
        }

        public Builder tooltip(class_2561 ... tooltips) {
            Validate.notEmpty((Object[])tooltips, (String)"`tooltips` cannot be empty", (Object[])new Object[0]);
            this.tooltipLines.addAll(List.of(tooltips));
            return this;
        }

        public ConfigCategory build() {
            Validate.notNull((Object)this.name, (String)"`name` must not be null to build `ConfigCategory`", (Object[])new Object[0]);
            ArrayList<OptionGroup> combinedGroups = new ArrayList<OptionGroup>();
            combinedGroups.add(new OptionGroupImpl((class_2561)class_2561.method_43473(), (class_2561)class_2561.method_43473(), ImmutableList.copyOf(this.rootOptions), false, true));
            combinedGroups.addAll(this.groups);
            Validate.notEmpty(combinedGroups, (String)"at least one option must be added to build `ConfigCategory`", (Object[])new Object[0]);
            class_5250 concatenatedTooltip = class_2561.method_43473();
            boolean first = true;
            for (class_2561 line : this.tooltipLines) {
                if (!first) {
                    concatenatedTooltip.method_27693("\n");
                }
                first = false;
                concatenatedTooltip.method_10852(line);
            }
            return new ConfigCategoryImpl(this.name, (ImmutableList<OptionGroup>)ImmutableList.copyOf(combinedGroups), (class_2561)concatenatedTooltip);
        }
    }
}

