/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.api.opus.OpusEncoder;
import de.maxhenkel.voicechat.config.ServerConfig;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.plugins.impl.opus.OpusManager;
import de.maxhenkel.voicechat.voice.client.AudioRecorder;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.ClientVoicechatConnection;
import de.maxhenkel.voicechat.voice.client.Denoiser;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.client.MicrophoneException;
import de.maxhenkel.voicechat.voice.client.NativeDependencyException;
import de.maxhenkel.voicechat.voice.client.PositionalAudioUtils;
import de.maxhenkel.voicechat.voice.client.VolumeManager;
import de.maxhenkel.voicechat.voice.client.microphone.Microphone;
import de.maxhenkel.voicechat.voice.client.microphone.MicrophoneManager;
import de.maxhenkel.voicechat.voice.common.MicPacket;
import de.maxhenkel.voicechat.voice.common.NetworkMessage;
import de.maxhenkel.voicechat.voice.common.Utils;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import net.minecraft.class_310;

public class MicThread
extends Thread {
    @Nullable
    private final ClientVoicechat client;
    @Nullable
    private final ClientVoicechatConnection connection;
    private final Microphone mic;
    private final VolumeManager volumeManager;
    private boolean running;
    private boolean microphoneLocked;
    private boolean wasWhispering;
    private final OpusEncoder encoder;
    @Nullable
    private Denoiser denoiser;
    private volatile boolean activating;
    private volatile int deactivationDelay;
    private volatile short[] lastBuff;
    private volatile boolean wasPTT;
    private final AtomicLong sequenceNumber = new AtomicLong();
    private volatile boolean stopPacketSent = true;

    public MicThread(@Nullable ClientVoicechat client, @Nullable ClientVoicechatConnection connection) throws MicrophoneException, NativeDependencyException {
        this.client = client;
        this.connection = connection;
        this.running = true;
        this.encoder = OpusManager.createEncoder(48000, 960, connection == null ? 1024 : connection.getData().getMtuSize(), connection == null ? ServerConfig.Codec.VOIP.getOpusValue() : connection.getData().getCodec().getOpusValue());
        this.denoiser = Denoiser.createDenoiser();
        if (this.denoiser == null) {
            Voicechat.LOGGER.warn("Denoiser not available");
        }
        this.volumeManager = new VolumeManager();
        this.setDaemon(true);
        this.setName("MicrophoneThread");
        this.mic = MicrophoneManager.createMicrophone();
    }

    @Override
    public void run() {
        while (this.running) {
            if (this.connection != null) {
                this.connection.checkTimeout();
            }
            if (this.microphoneLocked || ClientManager.getPlayerStateManager().isDisabled()) {
                this.activating = false;
                this.wasPTT = false;
                this.wasWhispering = false;
                this.flush();
                if (!this.microphoneLocked && ClientManager.getPlayerStateManager().isDisabled()) {
                    if (this.mic.isStarted()) {
                        this.mic.stop();
                    }
                    if (this.denoiser != null) {
                        this.denoiser.close();
                    }
                }
                Utils.sleep(10);
                continue;
            }
            short[] audio = this.pollMic();
            if (audio == null) continue;
            MicrophoneActivationType type = VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get();
            if (type.equals((Object)MicrophoneActivationType.PTT)) {
                this.ptt(audio);
                continue;
            }
            if (!type.equals((Object)MicrophoneActivationType.VOICE)) continue;
            this.voice(audio);
        }
    }

    @Nullable
    public short[] pollMic() {
        if (!this.mic.isStarted()) {
            this.mic.start();
        }
        if (this.denoiser != null && this.denoiser.isClosed()) {
            this.denoiser = Denoiser.createDenoiser();
        }
        if (this.mic.available() < 960) {
            Utils.sleep(5);
            return null;
        }
        short[] buff = this.mic.read();
        this.volumeManager.adjustVolumeMono(buff, VoicechatClient.CLIENT_CONFIG.microphoneAmplification.get().floatValue());
        return this.denoiseIfEnabled(buff);
    }

    private void voice(short[] audio) {
        this.wasPTT = false;
        if (ClientManager.getPlayerStateManager().isMuted()) {
            this.activating = false;
            this.wasWhispering = false;
            this.flush();
            return;
        }
        this.wasWhispering = ClientManager.getPttKeyHandler().isWhisperDown();
        int offset = Utils.getActivationOffset(audio, VoicechatClient.CLIENT_CONFIG.voiceActivationThreshold.get());
        if (this.activating) {
            if (offset < 0) {
                if (this.deactivationDelay >= VoicechatClient.CLIENT_CONFIG.deactivationDelay.get()) {
                    this.activating = false;
                    this.deactivationDelay = 0;
                    this.flush();
                } else {
                    this.sendAudioPacket(audio, this.wasWhispering);
                    ++this.deactivationDelay;
                }
            } else {
                this.sendAudioPacket(audio, this.wasWhispering);
            }
        } else if (offset > 0) {
            if (this.lastBuff != null) {
                this.sendAudioPacket(this.lastBuff, this.wasWhispering);
            }
            this.sendAudioPacket(audio, this.wasWhispering);
            this.activating = true;
        }
        this.lastBuff = audio;
    }

    private void ptt(short[] audio) {
        this.activating = false;
        if (!ClientManager.getPttKeyHandler().isAnyDown()) {
            if (this.wasPTT) {
                this.wasPTT = false;
                this.wasWhispering = false;
                this.flush();
            }
            return;
        }
        this.wasPTT = true;
        this.wasWhispering = ClientManager.getPttKeyHandler().isWhisperDown();
        this.sendAudioPacket(audio, this.wasWhispering);
    }

    public short[] denoiseIfEnabled(short[] audio) {
        if (this.denoiser != null && VoicechatClient.CLIENT_CONFIG.denoiser.get().booleanValue()) {
            return this.denoiser.denoise(audio);
        }
        return audio;
    }

    private void flush() {
        this.sendStopPacket();
        if (!this.encoder.isClosed()) {
            this.encoder.resetState();
        }
        if (this.client == null) {
            return;
        }
        AudioRecorder recorder = this.client.getRecorder();
        if (recorder == null) {
            return;
        }
        recorder.flushChunkThreaded(class_310.method_1551().method_1548().method_1677().getId());
    }

    public boolean isTalking() {
        return !this.microphoneLocked && (this.activating || this.wasPTT);
    }

    public boolean isWhispering() {
        return this.isTalking() && this.wasWhispering;
    }

    public void setMicrophoneLocked(boolean microphoneLocked) {
        this.microphoneLocked = microphoneLocked;
        this.activating = false;
        this.wasPTT = false;
        this.deactivationDelay = 0;
        this.lastBuff = null;
    }

    public void close() {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            this.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.mic.stop();
        this.mic.close();
        this.encoder.close();
        if (this.denoiser != null) {
            this.denoiser.close();
        }
        this.flush();
    }

    private void sendAudioPacket(short[] data, boolean whispering) {
        short[] audio = PluginManager.instance().onClientSound(data, whispering);
        if (audio == null) {
            return;
        }
        try {
            if (this.connection != null && this.connection.isAuthenticated()) {
                byte[] encoded = this.encoder.encode(audio);
                this.connection.sendToServer(new NetworkMessage(new MicPacket(encoded, whispering, this.sequenceNumber.getAndIncrement())));
                this.stopPacketSent = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.client != null && this.client.getRecorder() != null) {
                this.client.getRecorder().appendChunk(class_310.method_1551().method_1548().method_1677().getId(), System.currentTimeMillis(), PositionalAudioUtils.convertToStereo(audio));
            }
        }
        catch (IOException e) {
            Voicechat.LOGGER.error("Failed to record audio", (Throwable)e);
            this.client.setRecording(false);
        }
    }

    private void sendStopPacket() {
        if (this.stopPacketSent) {
            return;
        }
        if (this.connection == null || !this.connection.isAuthenticated()) {
            return;
        }
        try {
            this.connection.sendToServer(new NetworkMessage(new MicPacket(new byte[0], false, this.sequenceNumber.getAndIncrement())));
            this.stopPacketSent = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

