/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.plugins.impl.mp3;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.api.mp3.Mp3Decoder;
import de.maxhenkel.voicechat.lame4j.Lame;
import de.maxhenkel.voicechat.lame4j.LameDecoder;
import de.maxhenkel.voicechat.voice.common.Utils;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFormat;

public class Mp3DecoderImpl
implements Mp3Decoder {
    private final LameDecoder decoder;
    private IOException decodeError;
    @Nullable
    private short[] samples;
    @Nullable
    private AudioFormat audioFormat;

    public Mp3DecoderImpl(InputStream inputStream) {
        Voicechat.logDebug("Initializing LAME decoder version {}", Lame.INSTANCE.get_lame_version());
        this.decoder = new LameDecoder(inputStream);
    }

    private void decodeIfNecessary() throws IOException {
        if (this.decodeError != null) {
            throw this.decodeError;
        }
        try {
            if (this.samples == null) {
                this.samples = this.decoder.decode();
                this.audioFormat = this.decoder.format();
            }
        }
        catch (IOException e) {
            this.decodeError = e;
            throw e;
        }
    }

    @Override
    public short[] decode() throws IOException {
        this.decodeIfNecessary();
        return this.samples;
    }

    @Override
    public AudioFormat getAudioFormat() throws IOException {
        this.decodeIfNecessary();
        return this.audioFormat;
    }

    @Override
    public int getBitrate() throws IOException {
        this.decodeIfNecessary();
        return this.decoder.getBitrate();
    }

    @Nullable
    public static Mp3Decoder createDecoder(InputStream inputStream) {
        return Utils.createSafe(() -> new Mp3DecoderImpl(inputStream), e -> Voicechat.LOGGER.error("Failed to load LAME decoder: {}", (Object)e.getMessage()));
    }
}

