/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.socket;

import java.net.InetAddress;
import java.util.UUID;
import net.minecraft.class_3222;
import su.plo.voice.server.PlayerManager;
import su.plo.voice.server.VoiceServer;
import su.plo.voice.server.socket.SocketServerUDP;

public class SocketClientUDP {
    private final UUID playerUUID;
    private final InetAddress address;
    private final int port;
    private long keepAlive;
    private long sentKeepAlive;
    private String type;

    public SocketClientUDP(UUID player, String type, InetAddress address, int port) {
        this.playerUUID = player;
        this.type = type;
        this.address = address;
        this.port = port;
        this.keepAlive = System.currentTimeMillis();
    }

    public class_3222 getPlayer() {
        return PlayerManager.getByUUID(this.playerUUID);
    }

    public void close() {
        if (SocketServerUDP.clients.containsKey(this.playerUUID)) {
            if (!VoiceServer.getInstance().getConfig().getBoolean("disable_logs")) {
                class_3222 player = this.getPlayer();
                VoiceServer.LOGGER.info("Remove client UDP: " + player.method_7334().getName());
            }
            SocketServerUDP.clients.remove(this.playerUUID);
        }
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public long getKeepAlive() {
        return this.keepAlive;
    }

    public long getSentKeepAlive() {
        return this.sentKeepAlive;
    }

    public String getType() {
        return this.type;
    }

    public void setKeepAlive(long keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setSentKeepAlive(long sentKeepAlive) {
        this.sentKeepAlive = sentKeepAlive;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SocketClientUDP)) {
            return false;
        }
        SocketClientUDP other = (SocketClientUDP)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getKeepAlive() != other.getKeepAlive()) {
            return false;
        }
        if (this.getSentKeepAlive() != other.getSentKeepAlive()) {
            return false;
        }
        UUID this$playerUUID = this.getPlayerUUID();
        UUID other$playerUUID = other.getPlayerUUID();
        if (this$playerUUID == null ? other$playerUUID != null : !((Object)this$playerUUID).equals(other$playerUUID)) {
            return false;
        }
        InetAddress this$address = this.getAddress();
        InetAddress other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SocketClientUDP;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        long $keepAlive = this.getKeepAlive();
        result = result * 59 + (int)($keepAlive >>> 32 ^ $keepAlive);
        long $sentKeepAlive = this.getSentKeepAlive();
        result = result * 59 + (int)($sentKeepAlive >>> 32 ^ $sentKeepAlive);
        UUID $playerUUID = this.getPlayerUUID();
        result = result * 59 + ($playerUUID == null ? 43 : ((Object)$playerUUID).hashCode());
        InetAddress $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "SocketClientUDP(playerUUID=" + this.getPlayerUUID() + ", address=" + this.getAddress() + ", port=" + this.getPort() + ", keepAlive=" + this.getKeepAlive() + ", sentKeepAlive=" + this.getSentKeepAlive() + ", type=" + this.getType() + ")";
    }

    protected void setType(String type) {
        this.type = type;
    }
}

