/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.config;

import java.util.HashSet;
import java.util.List;

public class ServerConfig {
    private final String ip;
    private final int port;
    private final String proxyIp;
    private final int proxyPort;
    private final int sampleRate;
    private final HashSet<Integer> distances = new HashSet();
    private final int maxDistance;
    private final int defaultDistance;
    private final short maxPriorityDistance;
    private final int fadeDivisor;
    private final int priorityFadeDivisor;
    private final boolean disableVoiceActivation;

    public ServerConfig(String ip, int port, String proxyIp, int proxyPort, int sampleRate, List<Integer> distances, int defaultDistance, int maxPriorityDistance, boolean disableVoiceActivation, int fadeDivisor, int priorityFadeDivisor) {
        this.ip = ip;
        this.port = port;
        this.proxyIp = proxyIp;
        this.proxyPort = proxyPort;
        this.sampleRate = sampleRate;
        this.distances.addAll(distances);
        this.maxDistance = distances.get(distances.size() - 1);
        this.defaultDistance = defaultDistance;
        this.maxPriorityDistance = maxPriorityDistance > 0 ? (int)maxPriorityDistance : Short.MAX_VALUE;
        this.fadeDivisor = fadeDivisor;
        this.priorityFadeDivisor = priorityFadeDivisor;
        this.disableVoiceActivation = disableVoiceActivation;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getProxyIp() {
        return this.proxyIp;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public HashSet<Integer> getDistances() {
        return this.distances;
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    public int getDefaultDistance() {
        return this.defaultDistance;
    }

    public short getMaxPriorityDistance() {
        return this.maxPriorityDistance;
    }

    public int getFadeDivisor() {
        return this.fadeDivisor;
    }

    public int getPriorityFadeDivisor() {
        return this.priorityFadeDivisor;
    }

    public boolean isDisableVoiceActivation() {
        return this.disableVoiceActivation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerConfig)) {
            return false;
        }
        ServerConfig other = (ServerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getProxyPort() != other.getProxyPort()) {
            return false;
        }
        if (this.getSampleRate() != other.getSampleRate()) {
            return false;
        }
        if (this.getMaxDistance() != other.getMaxDistance()) {
            return false;
        }
        if (this.getDefaultDistance() != other.getDefaultDistance()) {
            return false;
        }
        if (this.getMaxPriorityDistance() != other.getMaxPriorityDistance()) {
            return false;
        }
        if (this.getFadeDivisor() != other.getFadeDivisor()) {
            return false;
        }
        if (this.getPriorityFadeDivisor() != other.getPriorityFadeDivisor()) {
            return false;
        }
        if (this.isDisableVoiceActivation() != other.isDisableVoiceActivation()) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$proxyIp = this.getProxyIp();
        String other$proxyIp = other.getProxyIp();
        if (this$proxyIp == null ? other$proxyIp != null : !this$proxyIp.equals(other$proxyIp)) {
            return false;
        }
        HashSet<Integer> this$distances = this.getDistances();
        HashSet<Integer> other$distances = other.getDistances();
        return !(this$distances == null ? other$distances != null : !((Object)this$distances).equals(other$distances));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + this.getProxyPort();
        result = result * 59 + this.getSampleRate();
        result = result * 59 + this.getMaxDistance();
        result = result * 59 + this.getDefaultDistance();
        result = result * 59 + this.getMaxPriorityDistance();
        result = result * 59 + this.getFadeDivisor();
        result = result * 59 + this.getPriorityFadeDivisor();
        result = result * 59 + (this.isDisableVoiceActivation() ? 79 : 97);
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $proxyIp = this.getProxyIp();
        result = result * 59 + ($proxyIp == null ? 43 : $proxyIp.hashCode());
        HashSet<Integer> $distances = this.getDistances();
        result = result * 59 + ($distances == null ? 43 : ((Object)$distances).hashCode());
        return result;
    }

    public String toString() {
        return "ServerConfig(ip=" + this.getIp() + ", port=" + this.getPort() + ", proxyIp=" + this.getProxyIp() + ", proxyPort=" + this.getProxyPort() + ", sampleRate=" + this.getSampleRate() + ", distances=" + this.getDistances() + ", maxDistance=" + this.getMaxDistance() + ", defaultDistance=" + this.getDefaultDistance() + ", maxPriorityDistance=" + this.getMaxPriorityDistance() + ", fadeDivisor=" + this.getFadeDivisor() + ", priorityFadeDivisor=" + this.getPriorityFadeDivisor() + ", disableVoiceActivation=" + this.isDisableVoiceActivation() + ")";
    }
}

