/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1159;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import su.plo.voice.client.VoiceClient;

public class SphereRenderer {
    private static final SphereRenderer INSTANCE = new SphereRenderer();
    private static final int stack = 18;
    private static final int slice = 36;
    private final class_287 bufferBuilder = new class_287(0x200000);
    private class_291 vertexBuffer;
    private int alpha = 150;
    private float radius = 8.0f;
    private long lastChanged;
    private boolean render;
    private boolean priority;

    public static SphereRenderer getInstance() {
        return INSTANCE;
    }

    public void setRadius(float radius, boolean priority) {
        this.setRadius(radius, (Boolean)VoiceClient.getClientConfig().visualizeDistance.get(), priority);
    }

    public void setRadius(float radius, boolean render, boolean priority) {
        this.radius = radius;
        this.priority = priority;
        if (radius > 150.0f || radius < 2.0f || !render) {
            this.render = false;
            return;
        }
        this.lastChanged = System.currentTimeMillis();
        this.alpha = 150;
        this.render = true;
    }

    public void render(class_4587 matrices, class_1159 matrix4f, class_310 client) {
        if (!this.render || !((Boolean)VoiceClient.getClientConfig().visualizeDistance.get()).booleanValue()) {
            return;
        }
        if (this.alpha == 0) {
            return;
        }
        if (System.currentTimeMillis() - this.lastChanged > 2000L) {
            this.alpha -= 5;
        }
        class_243 cameraPos = client.field_1773.method_19418().method_19326();
        class_243 center = client.field_1724.method_19538();
        this.bufferBuilder.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
        int r = this.priority ? 255 : 0;
        int g = this.priority ? 165 : 160;
        int b = 0;
        float stackStep = 0.17453292f;
        float sliceStep = 0.08726646f;
        for (int i = 0; i < 18; ++i) {
            float alpha0 = (float)(-1.5707963267948966 + (double)((float)i * stackStep));
            float alpha1 = alpha0 + stackStep;
            float r0 = (float)((double)this.radius * Math.cos(alpha0));
            float r1 = (float)((double)this.radius * Math.cos(alpha1));
            float y0 = (float)((double)this.radius * Math.sin(alpha0));
            float y1 = (float)((double)this.radius * Math.sin(alpha1));
            for (int j = 0; j < 72; ++j) {
                float beta = (float)j * sliceStep;
                float x0 = (float)((double)r0 * Math.cos(beta));
                float x1 = (float)((double)r1 * Math.cos(beta));
                float z0 = (float)((double)(-r0) * Math.sin(beta));
                float z1 = (float)((double)(-r1) * Math.sin(beta));
                this.bufferBuilder.method_22912((double)x0 + center.method_10216() - cameraPos.method_10216(), (double)y0 + center.method_10214() - cameraPos.method_10214(), (double)z0 + center.method_10215() - cameraPos.method_10215()).method_1336(r, g, b, this.alpha).method_1344();
                this.bufferBuilder.method_22912((double)x1 + center.method_10216() - cameraPos.method_10216(), (double)y1 + center.method_10214() - cameraPos.method_10214(), (double)z1 + center.method_10215() - cameraPos.method_10215()).method_1336(r, g, b, this.alpha).method_1344();
            }
        }
        if (this.vertexBuffer == null) {
            this.vertexBuffer = new class_291();
        }
        this.vertexBuffer.method_1353();
        this.vertexBuffer.method_1352(this.bufferBuilder.method_1326());
        RenderSystem.disableTexture();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
        RenderSystem.enablePolygonOffset();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrices.method_22903();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.setShader(class_757::method_34540);
        this.vertexBuffer.method_34427(matrices.method_23760().method_23761(), matrix4f, class_757.method_34540());
        matrices.method_22909();
        class_291.method_1354();
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableTexture();
    }
}

