/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1059;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2246;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import su.plo.voice.client.VoiceClient;
import su.plo.voice.client.config.ClientConfig;
import su.plo.voice.client.gui.particle.BlockDustParticle2D;
import su.plo.voice.client.gui.tabs.AboutTabWidget;
import su.plo.voice.client.gui.tabs.AdvancedTabWidget;
import su.plo.voice.client.gui.tabs.GeneralTabWidget;
import su.plo.voice.client.gui.tabs.KeyBindingsTabWidget;
import su.plo.voice.client.gui.tabs.TabWidget;
import su.plo.voice.client.gui.widgets.MicrophoneThresholdWidget;
import su.plo.voice.client.socket.SocketClientUDPQueue;
import su.plo.voice.client.sound.Compressor;
import su.plo.voice.client.sound.openal.CustomSource;
import su.plo.voice.client.utils.AudioUtils;

public class VoiceSettingsScreen
extends class_437 {
    private static final int minWidth = 640;
    private final class_310 client = class_310.method_1551();
    private TabWidget aboutWidget;
    private int active;
    private final List<class_4185> tabButtons = new ArrayList<class_4185>();
    private final List<TabWidget> tabWidgets = new ArrayList<TabWidget>();
    private List<class_4185> muteMicButtons;
    private List<class_4185> muteSpeakerButtons;
    private final List<BlockDustParticle2D> particles = new ArrayList<BlockDustParticle2D>();
    private final Random random = new Random();
    private boolean about;
    private int titleWidth;
    private long lastClick = 0L;
    private int clickCount = 0;
    private double microphoneValue = 0.0;
    private double microphoneDB = 0.0;
    private double highestDB = -127.0;
    private long lastUpdate = 0L;
    private CustomSource source;
    private final Compressor compressor = new Compressor();
    private List<class_2561> tooltip;

    public VoiceSettingsScreen() {
        super(VoiceSettingsScreen.getTranslatedTitle());
        AboutTabWidget.DeveloperEntry.loadSkins();
    }

    private static class_2561 getTranslatedTitle() {
        class_5250 title = class_2561.method_43469((String)"gui.plasmo_voice.title", (Object[])new Object[]{"Plasmo Voice " + VoiceClient.getInstance().getVersion()});
        class_2477 language = class_2477.method_10517();
        if (!language.method_4679("gui.plasmo_voice.title").contains("%s")) {
            return class_2561.method_43470((String)"Plasmo Voice ").method_10852((class_2561)class_2561.method_43470((String)VoiceClient.getInstance().getVersion())).method_10852((class_2561)class_2561.method_43470((String)" Settings"));
        }
        return title;
    }

    private float randomFloat(float min, float max) {
        return min + this.random.nextFloat() * (max - min);
    }

    public TabWidget getActiveTab() {
        return this.about ? this.aboutWidget : (this.tabWidgets.size() > 0 ? this.tabWidgets.get(this.active) : null);
    }

    public void setMicrophoneValue(byte[] buffer) {
        if (((Boolean)VoiceClient.getClientConfig().compressor.get()).booleanValue()) {
            buffer = this.compressor.compress(buffer);
        }
        this.microphoneDB = AudioUtils.getHighestAudioLevel(buffer);
        if (this.microphoneDB > this.highestDB) {
            this.highestDB = this.microphoneDB;
            this.lastUpdate = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.lastUpdate > 1000L) {
            this.highestDB = this.microphoneDB;
        }
        double value = 1.0 - this.microphoneDB / -60.0;
        this.microphoneValue = this.microphoneDB > -60.0 && value > this.microphoneValue ? 1.0 - this.microphoneDB / -60.0 : Math.max(this.microphoneValue - 0.02, 0.0);
        if (this.source != null) {
            byte[] finalBuffer = buffer;
            VoiceClient.getSoundEngine().runInContext(() -> {
                this.source.setVolume(((Double)VoiceClient.getClientConfig().voiceVolume.get()).floatValue());
                this.source.write(finalBuffer);
            });
        }
    }

    public void method_25393() {
        ArrayList<BlockDustParticle2D> toRemove = new ArrayList<BlockDustParticle2D>();
        for (BlockDustParticle2D particle : this.particles) {
            particle.tick();
            if (particle.isAlive()) continue;
            toRemove.add(particle);
        }
        this.particles.removeAll(toRemove);
        if (System.currentTimeMillis() - this.lastClick > 5000L) {
            this.clickCount = 0;
        }
    }

    public void method_25432() {
        super.method_25432();
        VoiceClient.getSoundEngine().runInContext(() -> {
            this.source.close();
            this.source = null;
        });
        VoiceClient.getClientConfig().save();
    }

    protected void method_25426() {
        super.method_25426();
        ClientConfig config = VoiceClient.getClientConfig();
        this.titleWidth = this.field_22793.method_27525((class_5348)this.field_22785);
        this.method_37067();
        this.addTab((class_2561)class_2561.method_43471((String)"gui.plasmo_voice.general"), new GeneralTabWidget(this.client, this));
        this.addTab((class_2561)class_2561.method_43471((String)"gui.plasmo_voice.advanced"), new AdvancedTabWidget(this.client, this));
        this.addTab((class_2561)class_2561.method_43471((String)"gui.plasmo_voice.hotkeys"), new KeyBindingsTabWidget(this.client, this));
        this.aboutWidget = new AboutTabWidget(this.client, this);
        class_344 muteMicHide = new class_344(this.field_22789 - 52, 8, 20, 20, 0, 32, 20, VoiceClient.ICONS, 256, 256, button -> {
            this.muteMicButtons.get((int)0).field_22764 = false;
            this.muteMicButtons.get((int)1).field_22764 = true;
            config.microphoneMuted.set(true);
        }, (button, matrices, mouseX, mouseY) -> this.setTooltip((List<class_2561>)ImmutableList.of((Object)class_2561.method_43471((String)"gui.plasmo_voice.toggle.microphone"), (Object)class_2561.method_43469((String)"gui.plasmo_voice.toggle.currently", (Object[])new Object[]{class_2561.method_43471((String)"gui.plasmo_voice.toggle.enabled").method_27692(class_124.field_1060)}).method_27692(class_124.field_1080))), null);
        class_344 muteMicShow = new class_344(this.field_22789 - 52, 8, 20, 20, 20, 32, 20, VoiceClient.ICONS, 256, 256, button -> {
            this.muteMicButtons.get((int)0).field_22764 = true;
            this.muteMicButtons.get((int)1).field_22764 = false;
            config.microphoneMuted.set(false);
            if (((Boolean)config.speakerMuted.get()).booleanValue()) {
                this.muteSpeakerButtons.get((int)0).field_22764 = true;
                this.muteSpeakerButtons.get((int)1).field_22764 = false;
                config.speakerMuted.set(false);
            }
        }, (button, matrices, mouseX, mouseY) -> this.setTooltip((List<class_2561>)ImmutableList.of((Object)class_2561.method_43471((String)"gui.plasmo_voice.toggle.microphone"), (Object)class_2561.method_43469((String)"gui.plasmo_voice.toggle.currently", (Object[])new Object[]{class_2561.method_43471((String)"gui.plasmo_voice.toggle.disabled").method_27692(class_124.field_1061)}).method_27692(class_124.field_1080))), null);
        muteMicHide.field_22764 = (Boolean)config.microphoneMuted.get() == false && (Boolean)config.speakerMuted.get() == false;
        muteMicShow.field_22764 = (Boolean)config.microphoneMuted.get() != false || (Boolean)config.speakerMuted.get() != false;
        class_344 muteSpeakerHide = new class_344(this.field_22789 - 28, 8, 20, 20, 0, 72, 20, VoiceClient.ICONS, 256, 256, button -> {
            this.muteSpeakerButtons.get((int)0).field_22764 = false;
            this.muteSpeakerButtons.get((int)1).field_22764 = true;
            config.speakerMuted.invert();
            SocketClientUDPQueue.closeAll();
            if (!((Boolean)config.microphoneMuted.get()).booleanValue()) {
                this.muteMicButtons.get((int)0).field_22764 = false;
                this.muteMicButtons.get((int)1).field_22764 = true;
            }
        }, (button, matrices, mouseX, mouseY) -> this.setTooltip((List<class_2561>)ImmutableList.of((Object)class_2561.method_43471((String)"gui.plasmo_voice.toggle.voice"), (Object)class_2561.method_43469((String)"gui.plasmo_voice.toggle.currently", (Object[])new Object[]{class_2561.method_43471((String)"gui.plasmo_voice.toggle.enabled").method_27692(class_124.field_1060)}).method_27692(class_124.field_1080))), null);
        class_344 muteSpeakerShow = new class_344(this.field_22789 - 28, 8, 20, 20, 20, 72, 20, VoiceClient.ICONS, 256, 256, button -> {
            this.muteSpeakerButtons.get((int)0).field_22764 = true;
            this.muteSpeakerButtons.get((int)1).field_22764 = false;
            config.speakerMuted.invert();
            if (!((Boolean)config.microphoneMuted.get()).booleanValue()) {
                this.muteMicButtons.get((int)0).field_22764 = true;
                this.muteMicButtons.get((int)1).field_22764 = false;
            }
        }, (button, matrices, mouseX, mouseY) -> this.setTooltip((List<class_2561>)ImmutableList.of((Object)class_2561.method_43471((String)"gui.plasmo_voice.toggle.voice"), (Object)class_2561.method_43469((String)"gui.plasmo_voice.toggle.currently", (Object[])new Object[]{class_2561.method_43471((String)"gui.plasmo_voice.toggle.disabled").method_27692(class_124.field_1061)}).method_27692(class_124.field_1080))), null);
        muteSpeakerHide.field_22764 = (Boolean)config.speakerMuted.get() == false;
        muteSpeakerShow.field_22764 = (Boolean)config.speakerMuted.get();
        this.muteMicButtons = ImmutableList.of((Object)muteMicHide, (Object)muteMicShow);
        this.muteSpeakerButtons = ImmutableList.of((Object)muteSpeakerHide, (Object)muteSpeakerShow);
    }

    public void updateGeneralTab() {
        this.tabWidgets.set(0, new GeneralTabWidget(this.client, this));
    }

    public void closeSpeaker() {
        for (TabWidget tab : this.tabWidgets) {
            for (TabWidget.Entry entry : tab.method_25396()) {
                Object e;
                if (!(entry instanceof TabWidget.OptionEntry) || !((e = entry.method_25396().get(0)) instanceof MicrophoneThresholdWidget)) continue;
                MicrophoneThresholdWidget microphoneTest = (MicrophoneThresholdWidget)((Object)e);
                microphoneTest.closeSpeaker();
            }
        }
    }

    private void addTab(class_2561 text, TabWidget drawable) {
        int textWidth = this.field_22793.method_27525((class_5348)text) + 16;
        int elementIndex = this.tabWidgets.size();
        class_4185 button = new class_4185(0, 0, textWidth, 20, text, btn -> {
            this.active = elementIndex;
            this.about = false;
            for (TabWidget widget : this.tabWidgets) {
                widget.onClose();
            }
            this.aboutWidget.method_25307(0.0);
            this.closeSpeaker();
        });
        this.tabButtons.add(button);
        this.tabWidgets.add(drawable);
    }

    public int getHeaderHeight() {
        if (this.field_22789 < 640) {
            return 64;
        }
        return 36;
    }

    private void renderParticles(float delta) {
        for (BlockDustParticle2D particle : this.particles) {
            class_289 tessellator = class_289.method_1348();
            class_287 bufferBuilder = tessellator.method_1349();
            RenderSystem.setShader(class_757::method_34543);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.depthFunc((int)515);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShaderTexture((int)0, (class_2960)class_1059.field_5275);
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            particle.buildGeometry((class_4588)bufferBuilder, delta);
            tessellator.method_1350();
        }
    }

    public void method_25420(class_4587 matrices) {
        int height = this.getHeaderHeight();
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (class_2960)field_22735);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        bufferBuilder.method_22912(0.0, (double)height, 0.0).method_22913(0.0f, (float)height / 32.0f + 0.0f).method_1336(64, 64, 64, 255).method_1344();
        bufferBuilder.method_22912((double)this.field_22789, (double)height, 0.0).method_22913((float)this.field_22789 / 32.0f, (float)height / 32.0f + 0.0f).method_1336(64, 64, 64, 255).method_1344();
        bufferBuilder.method_22912((double)this.field_22789, 0.0, 0.0).method_22913((float)this.field_22789 / 32.0f, 0.0f).method_1336(64, 64, 64, 255).method_1344();
        bufferBuilder.method_22912(0.0, 0.0, 0.0).method_22913(0.0f, 0.0f).method_1336(64, 64, 64, 255).method_1344();
        tesselator.method_1350();
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ZERO, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.disableTexture();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22912(0.0, (double)(height + 4), 0.0).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22912((double)this.field_22789, (double)(height + 4), 0.0).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22912((double)this.field_22789, (double)height, 0.0).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912(0.0, (double)height, 0.0).method_1336(0, 0, 0, 255).method_1344();
        tesselator.method_1350();
    }

    public void renderHeader(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.field_22793.method_30881(matrices, this.field_22785, 14.0f, 15.0f, 0xFFFFFF);
        int buttonX = 14;
        int buttonY = 36;
        if (this.field_22789 >= 640) {
            int buttonsWidth = (this.tabButtons.size() - 1) * 4;
            for (class_4185 button : this.tabButtons) {
                buttonsWidth += button.method_25368();
            }
            buttonX = this.field_22789 / 2 - buttonsWidth / 2;
            buttonY = 8;
        }
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            class_4185 button = this.tabButtons.get(i);
            button.field_22763 = this.about || i != this.active;
            button.field_22760 = buttonX;
            buttonX += button.method_25368() + 4;
            button.field_22761 = buttonY;
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc((int)519);
            button.method_25394(matrices, mouseX, mouseY, delta);
        }
        for (class_4185 button : this.muteMicButtons) {
            button.method_25394(matrices, mouseX, mouseY, delta);
        }
        for (class_4185 button : this.muteSpeakerButtons) {
            button.method_25394(matrices, mouseX, mouseY, delta);
        }
    }

    protected void method_37067() {
        super.method_37067();
        this.tabButtons.clear();
        this.tabWidgets.clear();
        this.muteMicButtons = null;
        this.muteSpeakerButtons = null;
        this.aboutWidget = null;
    }

    public List<? extends class_364> method_25396() {
        ArrayList<Object> list = new ArrayList<Object>(super.method_25396());
        list.addAll(this.tabButtons);
        if (this.muteMicButtons != null) {
            list.addAll(this.muteMicButtons);
        }
        if (this.muteSpeakerButtons != null) {
            list.addAll(this.muteSpeakerButtons);
        }
        if (this.tabWidgets.size() == 0) {
            return list;
        }
        if (!this.about) {
            list.add((class_364)this.tabWidgets.get(this.active));
        } else {
            list.add((Object)this.aboutWidget);
        }
        return list;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 || keyCode == 258) {
            for (TabWidget widget : this.tabWidgets) {
                if (!(widget instanceof KeyBindingsTabWidget) || !widget.method_25404(keyCode, scanCode, modifiers)) continue;
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.tabWidgets.get(this.active) instanceof KeyBindingsTabWidget) {
            this.tabWidgets.get(this.active).method_25406(mouseX, mouseY, button);
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && mouseX >= 14.0 && mouseX <= (double)(14 + this.titleWidth) && mouseY >= 15.0) {
            Objects.requireNonNull(this.field_22793);
            if (mouseY <= (double)(15 + 9) && !this.about) {
                if (this.clickCount > 10) {
                    this.about = true;
                    this.lastClick = 0L;
                    this.clickCount = 0;
                    this.client.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                    return true;
                }
                this.lastClick = System.currentTimeMillis();
                ++this.clickCount;
                this.client.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14697, (float)0.0f));
                for (int i = 0; i < 2 + this.random.nextInt(3); ++i) {
                    double d = 14.0f + this.randomFloat(0.0f, this.titleWidth);
                    Objects.requireNonNull(this.field_22793);
                    BlockDustParticle2D particle = new BlockDustParticle2D(d, 15.0f + this.randomFloat(0.0f, 9.0f), 1.0, -3.0, class_2246.field_10566.method_9564());
                    particle.setMaxAge(10 + this.random.nextInt(25));
                    particle.setVelocity(this.randomFloat(-0.25f, 0.25f), -0.25);
                    particle.setGravityStrength(4.0f);
                    particle.setScale(this.randomFloat(1.5f, 2.5f));
                    this.particles.add(particle);
                }
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.tooltip = null;
        super.method_25420(matrices);
        if (this.about) {
            this.aboutWidget.method_25394(matrices, mouseX, mouseY, delta);
        } else {
            this.tabWidgets.get(this.active).method_25394(matrices, mouseX, mouseY, delta);
        }
        this.method_25420(matrices);
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.renderHeader(matrices, mouseX, mouseY, delta);
        this.renderParticles(delta);
        if (this.tooltip != null) {
            this.method_30901(matrices, this.tooltip, mouseX, mouseY);
        }
    }

    public double getMicrophoneValue() {
        return this.microphoneValue;
    }

    public double getMicrophoneDB() {
        return this.microphoneDB;
    }

    public double getHighestDB() {
        return this.highestDB;
    }

    public void setSource(CustomSource source) {
        this.source = source;
    }

    public CustomSource getSource() {
        return this.source;
    }

    public Compressor getCompressor() {
        return this.compressor;
    }

    public void setTooltip(List<class_2561> tooltip) {
        this.tooltip = tooltip;
    }
}

