/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.ItemUtils;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.malilib.gui.GuiBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class InventoryUtils {
    private static final List<Integer> PICK_BLOCKABLE_SLOTS = new ArrayList<Integer>();
    private static int nextPickSlotIndex;

    public static void setPickBlockableSlots(String configStr) {
        String[] parts;
        PICK_BLOCKABLE_SLOTS.clear();
        for (String str : parts = configStr.split(",")) {
            try {
                int slotNum = Integer.parseInt(str) - 1;
                if (!class_1661.method_7380((int)slotNum) || PICK_BLOCKABLE_SLOTS.contains(slotNum)) continue;
                PICK_BLOCKABLE_SLOTS.add(slotNum);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static void setPickedItemToHand(class_1799 stack, class_310 mc) {
        int slotNum = mc.field_1724.method_31548().method_7395(stack);
        InventoryUtils.setPickedItemToHand(slotNum, stack, mc);
    }

    public static void setPickedItemToHand(int sourceSlot, class_1799 stack, class_310 mc) {
        class_746 player = mc.field_1724;
        class_1661 inventory = player.method_31548();
        if (class_1661.method_7380((int)sourceSlot)) {
            inventory.field_7545 = sourceSlot;
        } else {
            if (PICK_BLOCKABLE_SLOTS.size() == 0) {
                return;
            }
            int hotbarSlot = sourceSlot;
            if (sourceSlot == -1 || !class_1661.method_7380((int)sourceSlot)) {
                hotbarSlot = InventoryUtils.getEmptyPickBlockableHotbarSlot(inventory);
            }
            if (hotbarSlot == -1) {
                hotbarSlot = InventoryUtils.getPickBlockTargetSlot((class_1657)player);
            }
            if (hotbarSlot != -1) {
                inventory.field_7545 = hotbarSlot;
                if (EntityUtils.isCreativeMode((class_1657)player)) {
                    inventory.field_7547.set(hotbarSlot, (Object)stack.method_7972());
                } else {
                    fi.dy.masa.malilib.util.InventoryUtils.swapItemToMainHand((class_1799)stack.method_7972(), (class_310)mc);
                }
                WorldUtils.setEasyPlaceLastPickBlockTime();
            }
        }
    }

    public static void schematicWorldPickBlock(class_1799 stack, class_2338 pos, class_1937 schematicWorld, class_310 mc) {
        if (!stack.method_7960()) {
            class_1661 inv = mc.field_1724.method_31548();
            stack = stack.method_7972();
            if (EntityUtils.isCreativeMode((class_1657)mc.field_1724)) {
                class_2586 te = schematicWorld.method_8321(pos);
                if (GuiBase.isCtrlDown() && te != null && mc.field_1687.method_22347(pos)) {
                    ItemUtils.storeTEInStack(stack, te);
                }
                InventoryUtils.setPickedItemToHand(stack, mc);
                mc.field_1761.method_2909(mc.field_1724.method_5998(class_1268.field_5808), 36 + inv.field_7545);
            } else {
                boolean shouldPick;
                int slot = inv.method_7395(stack);
                boolean bl = shouldPick = inv.field_7545 != slot;
                if (shouldPick && slot != -1) {
                    InventoryUtils.setPickedItemToHand(stack, mc);
                } else if (slot == -1 && Configs.Generic.PICK_BLOCK_SHULKERS.getBooleanValue() && (slot = InventoryUtils.findSlotWithBoxWithItem((class_1703)mc.field_1724.field_7498, stack, false)) != -1) {
                    class_1799 boxStack = ((class_1735)mc.field_1724.field_7498.field_7761.get(slot)).method_7677();
                    InventoryUtils.setPickedItemToHand(boxStack, mc);
                }
            }
        }
    }

    private static boolean canPickToSlot(class_1661 inventory, int slotNum) {
        if (!PICK_BLOCKABLE_SLOTS.contains(slotNum)) {
            return false;
        }
        class_1799 stack = inventory.method_5438(slotNum);
        return stack.method_7960() || !stack.method_7909().method_7846();
    }

    private static int getPickBlockTargetSlot(class_1657 player) {
        if (PICK_BLOCKABLE_SLOTS.isEmpty()) {
            return -1;
        }
        int slotNum = player.method_31548().field_7545;
        if (InventoryUtils.canPickToSlot(player.method_31548(), slotNum)) {
            return slotNum;
        }
        if (nextPickSlotIndex >= PICK_BLOCKABLE_SLOTS.size()) {
            nextPickSlotIndex = 0;
        }
        for (int i = 0; i < PICK_BLOCKABLE_SLOTS.size(); ++i) {
            slotNum = PICK_BLOCKABLE_SLOTS.get(nextPickSlotIndex);
            if (++nextPickSlotIndex >= PICK_BLOCKABLE_SLOTS.size()) {
                nextPickSlotIndex = 0;
            }
            if (!InventoryUtils.canPickToSlot(player.method_31548(), slotNum)) continue;
            return slotNum;
        }
        return -1;
    }

    private static int getEmptyPickBlockableHotbarSlot(class_1661 inventory) {
        for (int i = 0; i < PICK_BLOCKABLE_SLOTS.size(); ++i) {
            class_1799 stack;
            int slotNum = PICK_BLOCKABLE_SLOTS.get(i);
            if (!class_1661.method_7380((int)slotNum) || !(stack = inventory.method_5438(slotNum)).method_7960()) continue;
            return slotNum;
        }
        return -1;
    }

    public static boolean doesShulkerBoxContainItem(class_1799 stack, class_1799 referenceItem) {
        class_2371 items = fi.dy.masa.malilib.util.InventoryUtils.getStoredItems((class_1799)stack);
        if (items.size() > 0) {
            for (class_1799 item : items) {
                if (!fi.dy.masa.malilib.util.InventoryUtils.areStacksEqual((class_1799)item, (class_1799)referenceItem)) continue;
                return true;
            }
        }
        return false;
    }

    public static int findSlotWithBoxWithItem(class_1703 container, class_1799 stackReference, boolean reverse) {
        int startSlot = reverse ? container.field_7761.size() - 1 : 0;
        int endSlot = reverse ? -1 : container.field_7761.size();
        int increment = reverse ? -1 : 1;
        boolean isPlayerInv = container instanceof class_1723;
        for (int slotNum = startSlot; slotNum != endSlot; slotNum += increment) {
            class_1735 slot = (class_1735)container.field_7761.get(slotNum);
            if (isPlayerInv && !fi.dy.masa.malilib.util.InventoryUtils.isRegularInventorySlot((int)slot.field_7874, (boolean)false) || !InventoryUtils.doesShulkerBoxContainItem(slot.method_7677(), stackReference)) continue;
            return slot.field_7874;
        }
        return -1;
    }
}

