/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.scheduler.tasks.TaskProcessChunkBase;
import fi.dy.masa.litematica.util.ToBooleanFunction;
import fi.dy.masa.malilib.util.IntBoundingBox;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_746;

public abstract class TaskProcessChunkMultiPhase
extends TaskProcessChunkBase {
    protected TaskPhase phase = TaskPhase.INIT;
    @Nullable
    protected class_1923 currentChunkPos;
    @Nullable
    protected IntBoundingBox currentBox;
    @Nullable
    protected Iterator<class_1297> entityIterator;
    @Nullable
    protected Iterator<class_2338> positionIterator;
    protected int maxCommandsPerTick = 16;
    protected int processedChunksThisTick;
    protected int sentCommandsThisTick;
    protected long gameRuleProbeTimeout;
    protected long maxGameRuleProbeTime = 2000000000L;
    protected long taskStartTimeForCurrentTick;
    protected boolean shouldEnableFeedback;
    protected ToBooleanFunction<class_2561> gameRuleListener = this::checkCommandFeedbackGameRuleState;
    protected Runnable initTask = this::initPhaseStartProbe;
    protected Runnable probeTask = this::probePhase;
    protected Runnable waitForChunkTask = this::fetchNextChunk;
    protected Runnable processBoxBlocksTask;
    protected Runnable processBoxEntitiesTask;

    protected TaskProcessChunkMultiPhase(String nameOnHud) {
        super(nameOnHud);
    }

    protected boolean executeMultiPhase() {
        long currentTime;
        long elapsedTickTime;
        this.taskStartTimeForCurrentTick = class_156.method_648();
        this.sentCommandsThisTick = 0;
        this.processedChunksThisTick = 0;
        if (this.phase == TaskPhase.INIT) {
            this.initTask.run();
        }
        if (this.phase == TaskPhase.GAME_RULE_PROBE) {
            this.probeTask.run();
            return false;
        }
        if (this.currentChunkPos != null && !this.canProcessChunk(this.currentChunkPos)) {
            return false;
        }
        int commandsLast = -1;
        class_1923 lastChunk = this.currentChunkPos;
        while (!(this.sentCommandsThisTick >= this.maxCommandsPerTick || this.sentCommandsThisTick <= commandsLast && Objects.equals(lastChunk, this.currentChunkPos) || (elapsedTickTime = (currentTime = class_156.method_648()) - this.taskStartTimeForCurrentTick) >= 25000000L)) {
            commandsLast = this.sentCommandsThisTick;
            lastChunk = this.currentChunkPos;
            if (this.phase == TaskPhase.WAIT_FOR_CHUNKS) {
                this.waitForChunkTask.run();
            }
            if (this.phase == TaskPhase.PROCESS_BOX_BLOCKS) {
                this.processBoxBlocksTask.run();
            }
            if (this.phase == TaskPhase.PROCESS_BOX_ENTITIES) {
                this.processBoxEntitiesTask.run();
            }
            if (this.phase != TaskPhase.FINISHED) continue;
            return true;
        }
        if (this.processedChunksThisTick > 0) {
            this.updateInfoHudLines();
        }
        return false;
    }

    protected void initPhaseStartProbe() {
        if (Configs.Generic.COMMAND_DISABLE_FEEDBACK.getBooleanValue()) {
            DataManager.addChatListener(this.gameRuleListener);
            this.sendCommandToServer("gamerule sendCommandFeedback", this.mc.field_1724);
            this.gameRuleProbeTimeout = class_156.method_648() + this.maxGameRuleProbeTime;
            this.phase = TaskPhase.GAME_RULE_PROBE;
        } else {
            this.shouldEnableFeedback = false;
            this.phase = TaskPhase.WAIT_FOR_CHUNKS;
        }
    }

    protected void probePhase() {
        if (class_156.method_648() > this.gameRuleProbeTimeout) {
            this.shouldEnableFeedback = false;
            this.phase = TaskPhase.WAIT_FOR_CHUNKS;
        }
    }

    protected boolean checkCommandFeedbackGameRuleState(class_2561 message) {
        class_2588 text;
        class_5250 mutableText;
        class_7417 class_74172;
        if (message instanceof class_5250 && (class_74172 = (mutableText = (class_5250)message).method_10851()) instanceof class_2588 && "commands.gamerule.query".equals((text = (class_2588)class_74172).method_11022())) {
            Object[] args = text.method_11023();
            this.shouldEnableFeedback = args.length == 1 && args[0].equals("true");
            this.phase = TaskPhase.WAIT_FOR_CHUNKS;
            if (this.shouldEnableFeedback) {
                this.sendCommandToServer("gamerule sendCommandFeedback false", this.mc.field_1724);
            }
            return true;
        }
        return false;
    }

    protected void fetchNextChunk() {
        if (!this.pendingChunks.isEmpty()) {
            this.sortChunkList();
            class_1923 pos = (class_1923)this.pendingChunks.get(0);
            if (this.canProcessChunk(pos)) {
                this.currentChunkPos = pos;
                this.onNextChunkFetched(pos);
            }
        } else {
            this.phase = TaskPhase.FINISHED;
            this.finished = true;
        }
    }

    protected void onNextChunkFetched(class_1923 pos) {
    }

    protected void startNextBox(class_1923 pos) {
        List list = this.boxesInChunks.get((Object)pos);
        if (!list.isEmpty()) {
            this.currentBox = (IntBoundingBox)list.get(0);
            this.onStartNextBox(this.currentBox);
        } else {
            this.currentBox = null;
            this.phase = TaskPhase.WAIT_FOR_CHUNKS;
        }
    }

    protected void onStartNextBox(IntBoundingBox box) {
    }

    protected void onFinishedProcessingBox(class_1923 pos, IntBoundingBox box) {
        this.boxesInChunks.remove((Object)pos, (Object)box);
        this.currentBox = null;
        this.entityIterator = null;
        this.positionIterator = null;
        if (this.boxesInChunks.get((Object)pos).isEmpty()) {
            this.finishProcessingChunk(pos);
        } else {
            this.startNextBox(pos);
        }
    }

    protected void finishProcessingChunk(class_1923 pos) {
        this.boxesInChunks.removeAll((Object)pos);
        this.pendingChunks.remove(pos);
        this.currentChunkPos = null;
        ++this.processedChunksThisTick;
        this.phase = TaskPhase.WAIT_FOR_CHUNKS;
        this.onFinishedProcessingChunk(pos);
    }

    protected void onFinishedProcessingChunk(class_1923 pos) {
    }

    protected void sendCommand(String command, class_746 player) {
        this.sendCommandToServer(command, player);
        ++this.sentCommandsThisTick;
    }

    protected void sendCommandToServer(String command, class_746 player) {
        player.method_44099(command);
    }

    public static enum TaskPhase {
        INIT,
        GAME_RULE_PROBE,
        WAIT_FOR_CHUNKS,
        PROCESS_BOX_BLOCKS,
        PROCESS_BOX_ENTITIES,
        FINISHED;

    }
}

