/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl.api;

import com.google.common.collect.ImmutableList;
import dev.isxander.yacl.api.Option;
import dev.isxander.yacl.impl.OptionGroupImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public interface OptionGroup {
    public class_2561 name();

    public class_2561 tooltip();

    @NotNull
    public ImmutableList<Option<?>> options();

    public boolean collapsed();

    public boolean isRoot();

    public static Builder createBuilder() {
        return new Builder();
    }

    public static class Builder {
        private class_2561 name = class_2561.method_43473();
        private final List<class_2561> tooltipLines = new ArrayList<class_2561>();
        private final List<Option<?>> options = new ArrayList();
        private boolean collapsed = false;

        private Builder() {
        }

        public Builder name(@NotNull class_2561 name) {
            Validate.notNull((Object)name, (String)"`name` must not be null", (Object[])new Object[0]);
            this.name = name;
            return this;
        }

        public Builder tooltip(class_2561 ... tooltips) {
            Validate.notEmpty((Object[])tooltips, (String)"`tooltips` cannot be empty", (Object[])new Object[0]);
            this.tooltipLines.addAll(List.of(tooltips));
            return this;
        }

        public Builder option(@NotNull Option<?> option) {
            Validate.notNull(option, (String)"`option` must not be null", (Object[])new Object[0]);
            this.options.add(option);
            return this;
        }

        public Builder options(@NotNull Collection<? extends Option<?>> options) {
            Validate.notEmpty(options, (String)"`options` must not be empty", (Object[])new Object[0]);
            this.options.addAll(options);
            return this;
        }

        public Builder collapsed(boolean collapsible) {
            this.collapsed = collapsible;
            return this;
        }

        public OptionGroup build() {
            Validate.notEmpty(this.options, (String)"`options` must not be empty to build `OptionGroup`", (Object[])new Object[0]);
            class_5250 concatenatedTooltip = class_2561.method_43473();
            boolean first = true;
            for (class_2561 line : this.tooltipLines) {
                if (!first) {
                    concatenatedTooltip.method_27693("\n");
                }
                first = false;
                concatenatedTooltip.method_10852(line);
            }
            return new OptionGroupImpl(this.name, (class_2561)concatenatedTooltip, ImmutableList.copyOf(this.options), this.collapsed, false);
        }
    }
}

