/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.stacktrace;

import fudge.notenoughcrashes.NecConfig;
import fudge.notenoughcrashes.NotEnoughCrashes;
import fudge.notenoughcrashes.platform.CommonModMetadata;
import fudge.notenoughcrashes.platform.ModsByLocation;
import fudge.notenoughcrashes.platform.NecPlatform;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_128;
import org.jetbrains.annotations.NotNull;

public final class ModIdentifier {
    private static final Map<class_128, Set<CommonModMetadata>> suspectedModsCache = new HashMap<class_128, Set<CommonModMetadata>>();
    private static final boolean FORCE_DEBUG = false;

    public static Set<CommonModMetadata> getSuspectedModsOf(class_128 report) {
        return suspectedModsCache.computeIfAbsent(report, ignored -> ModIdentifier.identifyFromStacktrace(report.method_564()));
    }

    @NotNull
    private static Set<CommonModMetadata> identifyFromStacktrace(Throwable e) {
        HashSet<CommonModMetadata> mods = new HashSet<CommonModMetadata>();
        ModIdentifier.visitChildrenThrowables(e, throwable -> {
            for (CommonModMetadata newMod : ModIdentifier.identifyFromThrowable(throwable)) {
                if (!mods.stream().noneMatch(mod -> mod.id().equals(newMod.id()))) continue;
                mods.add(newMod);
            }
        });
        return mods;
    }

    private static void visitChildrenThrowables(Throwable e, Consumer<Throwable> visitor) {
        visitor.accept(e);
        for (Throwable child : e.getSuppressed()) {
            ModIdentifier.visitChildrenThrowables(child, visitor);
        }
    }

    private static Set<CommonModMetadata> identifyFromThrowable(Throwable e) {
        ModsByLocation modMap = NecPlatform.instance().getModsAtLocationsInDisk();
        LinkedHashSet<String> involvedClasses = new LinkedHashSet<String>();
        while (e != null) {
            for (StackTraceElement element : e.getStackTrace()) {
                involvedClasses.add(element.getClassName());
            }
            e = e.getCause();
        }
        LinkedHashSet<CommonModMetadata> mods = new LinkedHashSet<CommonModMetadata>();
        for (String className : involvedClasses) {
            Set<CommonModMetadata> classMods = ModIdentifier.identifyFromClass(className, modMap);
            mods.addAll(classMods);
        }
        ModIdentifier.debug(modMap::toString);
        return mods;
    }

    private static void debug(Supplier<String> message) {
        if (NecConfig.instance().debugModIdentification) {
            NotEnoughCrashes.getLogger().info(message.get());
        }
    }

    @NotNull
    private static Set<CommonModMetadata> identifyFromClass(String className, ModsByLocation modMap) {
        if (className.startsWith("org.spongepowered.asm.mixin.")) {
            ModIdentifier.debug(() -> "Ignoring class " + className + " for identification because it is a mixin class");
            return Collections.emptySet();
        }
        try {
            Class<?> clazz = Class.forName(className);
            CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
            if (codeSource == null) {
                ModIdentifier.debug(() -> "Ignoring class " + className + " for identification because the code source could not be found");
                return Collections.emptySet();
            }
            URL url = codeSource.getLocation();
            if (url == null) {
                NotEnoughCrashes.getLogger().warn("Failed to identify mod for " + className);
                return Collections.emptySet();
            }
            Set<CommonModMetadata> mods = ModIdentifier.getModsAt(Paths.get(url.toURI()), modMap);
            if (NecConfig.instance().debugModIdentification && !mods.isEmpty()) {
                ModIdentifier.debug(() -> "Successfully placed blame of '" + className + "' on '" + ((CommonModMetadata)mods.stream().findFirst().get()).name() + "'");
            }
            return mods;
        }
        catch (ClassNotFoundException | NoClassDefFoundError | URISyntaxException e) {
            ModIdentifier.debug(() -> "Ignoring class " + className + " for identification because an error occurred");
            if (NecConfig.instance().debugModIdentification) {
                e.printStackTrace();
            }
            return Collections.emptySet();
        }
    }

    @NotNull
    private static Set<CommonModMetadata> getModsAt(Path path, ModsByLocation modMap) {
        Set<CommonModMetadata> mod = modMap.get(path);
        if (mod != null) {
            return mod;
        }
        if (NecPlatform.instance().isDevelopmentEnvironment()) {
            String resourcesPathString = path.toString().replace("\\", "/").replace("common/build/classes/java/main", "fabric/build/resources/main").replace("common/build/classes/kotlin/main", "fabric/build/resources/main").replace("classes/java/main", "resources/main").replace("classes/kotlin/main", "resources/main");
            Path resourcesPath = Paths.get(resourcesPathString, new String[0]);
            return modMap.getOrEmpty(resourcesPath);
        }
        ModIdentifier.debug(() -> "Mod at path '" + path.toAbsolutePath() + "' is at fault, but it could not be found in the map of mod paths: ");
        return Collections.emptySet();
    }
}

