/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.SecretPacket;
import de.maxhenkel.voicechat.permission.PermissionManager;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.server.Server;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3176;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ServerVoiceEvents {
    private final Map<UUID, Integer> clientCompatibilities = new ConcurrentHashMap<UUID, Integer>();
    private Server server;

    public ServerVoiceEvents() {
        CommonCompatibilityManager.INSTANCE.onServerStarting(this::serverStarting);
        CommonCompatibilityManager.INSTANCE.onPlayerLoggedIn(this::playerLoggedIn);
        CommonCompatibilityManager.INSTANCE.onPlayerLoggedOut(this::playerLoggedOut);
        CommonCompatibilityManager.INSTANCE.onServerStopping(this::serverStopping);
        CommonCompatibilityManager.INSTANCE.getNetManager().requestSecretChannel.setServerListener((server, player, handler, packet) -> {
            Voicechat.LOGGER.info("Received secret request of {} ({})", (Object)player.method_5476().getString(), (Object)packet.getCompatibilityVersion());
            this.clientCompatibilities.put(player.method_5667(), packet.getCompatibilityVersion());
            if (packet.getCompatibilityVersion() != Voicechat.COMPATIBILITY_VERSION) {
                Voicechat.LOGGER.warn("Connected client {} has incompatible voice chat version (server={}, client={})", (Object)player.method_5477().getString(), (Object)Voicechat.COMPATIBILITY_VERSION, (Object)packet.getCompatibilityVersion());
                player.method_43496(this.getIncompatibleMessage(packet.getCompatibilityVersion()));
            } else {
                this.initializePlayerConnection(player);
            }
        });
    }

    public class_2561 getIncompatibleMessage(int clientCompatibilityVersion) {
        if (clientCompatibilityVersion <= 6) {
            return class_2561.method_43470((String)"Your voice chat version is not compatible with the servers version.\nPlease install version ").method_10852((class_2561)class_2561.method_43470((String)CommonCompatibilityManager.INSTANCE.getModVersion()).method_27692(class_124.field_1067)).method_27693(" of ").method_10852((class_2561)class_2561.method_43470((String)CommonCompatibilityManager.INSTANCE.getModName()).method_27692(class_124.field_1067)).method_27693(".");
        }
        return class_2561.method_43469((String)"message.voicechat.incompatible_version", (Object[])new Object[]{class_2561.method_43470((String)CommonCompatibilityManager.INSTANCE.getModVersion()).method_27692(class_124.field_1067), class_2561.method_43470((String)CommonCompatibilityManager.INSTANCE.getModName()).method_27692(class_124.field_1067)});
    }

    public boolean isCompatible(class_3222 player) {
        return this.clientCompatibilities.getOrDefault(player.method_5667(), -1) == Voicechat.COMPATIBILITY_VERSION;
    }

    public void serverStarting(MinecraftServer mcServer) {
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
        if (!(mcServer instanceof class_3176) && VoicechatClient.CLIENT_CONFIG != null && !VoicechatClient.CLIENT_CONFIG.runLocalServer.get().booleanValue()) {
            Voicechat.LOGGER.info("Disabling voice chat in singleplayer");
            return;
        }
        if (mcServer instanceof class_3176 && !mcServer.method_3828()) {
            Voicechat.LOGGER.warn("Running in offline mode - Voice chat encryption is not secure!");
        }
        try {
            this.server = new Server(mcServer);
            this.server.start();
            PluginManager.instance().onServerStarted();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initializePlayerConnection(class_3222 player) {
        if (this.server == null) {
            return;
        }
        CommonCompatibilityManager.INSTANCE.emitPlayerCompatibilityCheckSucceeded(player);
        if (!PermissionManager.INSTANCE.CONNECT_PERMISSION.hasPermission(player)) {
            Voicechat.LOGGER.info("Player {} has no permission to connect to the voice chat", (Object)player.method_5476().getString());
            return;
        }
        UUID secret = this.server.getSecret(player.method_5667());
        NetManager.sendToClient(player, new SecretPacket(player, secret, this.server.getPort(), Voicechat.SERVER_CONFIG));
        Voicechat.LOGGER.info("Sent secret to {}", (Object)player.method_5476().getString());
    }

    public void playerLoggedIn(final class_3222 serverPlayer) {
        if (!Voicechat.SERVER_CONFIG.forceVoiceChat.get().booleanValue()) {
            return;
        }
        final Timer timer = new Timer("%s-login-timer".formatted(serverPlayer.method_7334().getName()), true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                timer.cancel();
                timer.purge();
                if (!serverPlayer.field_13995.method_3806()) {
                    return;
                }
                if (!serverPlayer.field_13987.field_14127.method_10758()) {
                    return;
                }
                if (!ServerVoiceEvents.this.isCompatible(serverPlayer)) {
                    serverPlayer.field_13995.execute(() -> serverPlayer2.field_13987.method_14367((class_2561)class_2561.method_43470((String)"You need %s %s to play on this server".formatted(CommonCompatibilityManager.INSTANCE.getModName(), CommonCompatibilityManager.INSTANCE.getModVersion()))));
                }
            }
        }, Voicechat.SERVER_CONFIG.loginTimeout.get().intValue());
    }

    public void playerLoggedOut(class_3222 player) {
        this.clientCompatibilities.remove(player.method_5667());
        if (this.server == null) {
            return;
        }
        this.server.disconnectClient(player.method_5667());
        Voicechat.LOGGER.info("Disconnecting client " + player.method_5476().getString());
    }

    @Nullable
    public Server getServer() {
        return this.server;
    }

    public void serverStopping(MinecraftServer mcServer) {
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
    }
}

