/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.config;

import com.sun.jna.Platform;
import de.maxhenkel.voicechat.config.ClientConfig;
import de.maxhenkel.voicechat.configbuilder.ConfigBuilder;
import de.maxhenkel.voicechat.voice.client.GroupPlayerIconOrientation;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.client.speaker.AudioType;

public class FabricClientConfig
extends ClientConfig {
    public FabricClientConfig(ConfigBuilder builder) {
        this.voiceChatVolume = builder.doubleEntry("voice_chat_volume", 1.0, 0.0, 2.0);
        this.voiceActivationThreshold = builder.doubleEntry("voice_activation_threshold", -50.0, -127.0, 0.0);
        this.microphoneAmplification = builder.doubleEntry("microphone_amplification", 1.0, 0.0, 4.0);
        this.microphoneActivationType = builder.enumEntry("microphone_activation_type", MicrophoneActivationType.PTT);
        this.outputBufferSize = builder.integerEntry("output_buffer_size", 5, 1, 16);
        this.audioPacketThreshold = builder.integerEntry("audio_packet_threshold", 3, 0, 16);
        this.deactivationDelay = builder.integerEntry("voice_deactivation_delay", 25, 0, 100);
        this.microphone = builder.stringEntry("microphone", "");
        this.speaker = builder.stringEntry("speaker", "");
        this.muted = builder.booleanEntry("muted", false);
        this.disabled = builder.booleanEntry("disabled", false);
        this.hideIcons = builder.booleanEntry("hide_icons", false);
        this.showGroupHUD = builder.booleanEntry("show_group_hud", true);
        this.showOwnGroupIcon = builder.booleanEntry("show_own_group_icon", true);
        this.groupHudIconScale = builder.doubleEntry("group_hud_icon_scale", 2.0, 0.01, 10.0);
        this.groupPlayerIconOrientation = builder.enumEntry("group_player_icon_orientation", GroupPlayerIconOrientation.VERTICAL);
        this.groupPlayerIconPosX = builder.integerEntry("group_player_icon_pos_x", 4, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.groupPlayerIconPosY = builder.integerEntry("group_player_icon_pos_y", 4, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.hudIconPosX = builder.integerEntry("hud_icon_pos_x", 16, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.hudIconPosY = builder.integerEntry("hud_icon_pos_y", -16, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.hudIconScale = builder.doubleEntry("hud_icon_scale", 1.0, 0.01, 10.0);
        this.recordingDestination = builder.stringEntry("recording_destination", "");
        this.recordingQuality = builder.integerEntry("recording_quality", 2, 0, 9);
        this.denoiser = builder.booleanEntry("denoiser", false);
        this.runLocalServer = builder.booleanEntry("run_local_server", true);
        this.javaMicrophoneImplementation = builder.booleanEntry("java_microphone_implementation", Platform.isMac());
        this.macosMicrophoneWorkaround = builder.booleanEntry("macos_microphone_workaround", true);
        this.showFakePlayersDisconnected = builder.booleanEntry("show_fake_players_disconnected", false);
        this.offlinePlayerVolumeAdjustment = builder.booleanEntry("offline_player_volume_adjustment", false);
        this.audioType = builder.enumEntry("audio_type", AudioType.NORMAL);
        this.useNatives = builder.booleanEntry("use_natives", true);
        if (Platform.isMac() && !((Boolean)this.javaMicrophoneImplementation.get()).booleanValue()) {
            this.javaMicrophoneImplementation.set(true).save();
        }
    }
}

