/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.init;

import java.util.Map;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1269;
import net.minecraft.class_2388;
import net.minecraft.class_2396;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import randommcsomethin.fallingleaves.FallingLeavesClient;
import randommcsomethin.fallingleaves.config.LeafSettingsEntry;
import randommcsomethin.fallingleaves.init.Config;
import randommcsomethin.fallingleaves.particle.FallingLeafParticle;
import randommcsomethin.fallingleaves.util.LeafUtil;
import randommcsomethin.fallingleaves.util.RegistryUtil;
import randommcsomethin.fallingleaves.util.TextureCache;

public class Leaves {
    public static class_2396<class_2388> FALLING_LEAF;
    public static class_2396<class_2388> FALLING_CONIFER_LEAF;
    private static boolean preLoadedRegisteredLeafBlocks;

    public static void init() {
        FallingLeavesClient.LOGGER.debug("Registering leaf particles.");
        FALLING_LEAF = RegistryUtil.registerNewLeafParticle("falling_leaf");
        FALLING_CONIFER_LEAF = RegistryUtil.registerNewLeafParticle("falling_leaf_conifer");
        ParticleFactoryRegistry.getInstance().register(FALLING_LEAF, FallingLeafParticle.BlockStateFactory::new);
        ParticleFactoryRegistry.getInstance().register(FALLING_CONIFER_LEAF, FallingLeafParticle.BlockStateFactory::new);
        Leaves.registerReloadListener();
        Leaves.registerAttackBlockLeaves();
    }

    private static void registerReloadListener() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public void method_14491(class_3300 resourceManager) {
                if (!preLoadedRegisteredLeafBlocks) {
                    for (Map.Entry<class_2960, LeafSettingsEntry> registered : LeafUtil.getRegisteredLeafBlocks(false).entrySet()) {
                        Config.CONFIG.leafSettings.computeIfAbsent(registered.getKey(), k -> (LeafSettingsEntry)registered.getValue());
                    }
                    preLoadedRegisteredLeafBlocks = true;
                }
                TextureCache.INST.clear();
            }

            public class_2960 getFabricId() {
                return RegistryUtil.makeId("resource_reload_listener");
            }
        });
    }

    private static void registerAttackBlockLeaves() {
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            if (!(Config.CONFIG.enabled && Config.CONFIG.leavesOnBlockHit && world.field_9236)) {
                return class_1269.field_5811;
            }
            class_2680 state = world.method_8320(pos);
            LeafSettingsEntry leafSettings = LeafUtil.getLeafSettingsEntry(state);
            if (leafSettings != null) {
                int count = 0;
                for (int i = 0; i < 3; ++i) {
                    if (!world.field_9229.method_43056()) continue;
                    ++count;
                }
                LeafUtil.spawnLeafParticles(count, false, state, world, pos, world.field_9229, leafSettings);
            }
            return class_1269.field_5811;
        });
    }

    static {
        preLoadedRegisteredLeafBlocks = false;
    }
}

