/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.voice.common.SoundPacket;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class AudioPacketBuffer {
    private final int packetThreshold;
    @Nullable
    private List<SoundPacket<?>> packetBuffer;
    private long lastSequenceNumber = -1L;
    private boolean isFlushingBuffer;

    public AudioPacketBuffer(int packetThreshold) {
        this.packetThreshold = packetThreshold;
        if (packetThreshold > 0) {
            this.packetBuffer = new ArrayList();
        }
    }

    @Nullable
    public SoundPacket<?> poll(BlockingQueue<SoundPacket<?>> queue) throws InterruptedException {
        if (this.packetThreshold <= 0) {
            return queue.poll(10L, TimeUnit.MILLISECONDS);
        }
        SoundPacket<?> packet = this.getNext();
        if (packet != null) {
            return packet;
        }
        packet = queue.poll(5L, TimeUnit.MILLISECONDS);
        if (packet != null) {
            if (packet.getSequenceNumber() == this.lastSequenceNumber + 1L || this.lastSequenceNumber < 0L) {
                this.lastSequenceNumber = packet.getSequenceNumber();
                return packet;
            }
            this.addSorted(packet);
        }
        return null;
    }

    private void addSorted(SoundPacket<?> packet) {
        if (packet.getData().length <= 0) {
            this.isFlushingBuffer = true;
        }
        this.packetBuffer.add(packet);
        this.packetBuffer.sort(Comparator.comparingLong(SoundPacket::getSequenceNumber));
    }

    @Nullable
    private SoundPacket<?> getNext() {
        if (this.packetBuffer.size() > this.packetThreshold || this.isFlushingBuffer) {
            boolean bl = this.isFlushingBuffer = this.packetBuffer.size() != 0;
            if (this.packetBuffer.size() != 0) {
                SoundPacket<?> packet = this.packetBuffer.remove(0);
                this.lastSequenceNumber = packet.getSequenceNumber();
                return packet;
            }
            return null;
        }
        return null;
    }

    public void clear() {
        if (this.packetBuffer != null) {
            this.packetBuffer.clear();
        }
        this.lastSequenceNumber = -1L;
        this.isFlushingBuffer = false;
    }
}

