/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.plugins.impl;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.api.ServerPlayer;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.plugins.impl.GroupImpl;
import de.maxhenkel.voicechat.plugins.impl.ServerPlayerImpl;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.server.Group;
import de.maxhenkel.voicechat.voice.server.Server;
import javax.annotation.Nullable;
import net.minecraft.class_3222;

public class VoicechatConnectionImpl
implements VoicechatConnection {
    private final ServerPlayer player;
    private final class_3222 serverPlayer;
    private final PlayerState state;
    @Nullable
    private final de.maxhenkel.voicechat.api.Group group;

    public VoicechatConnectionImpl(class_3222 player, PlayerState state) {
        this.serverPlayer = player;
        this.player = new ServerPlayerImpl(player);
        this.state = state;
        this.group = GroupImpl.create(state);
    }

    @Nullable
    public static VoicechatConnectionImpl fromPlayer(class_3222 player) {
        Server server = Voicechat.SERVER.getServer();
        if (server == null) {
            return null;
        }
        PlayerState state = server.getPlayerStateManager().getState(player.method_5667());
        if (state == null) {
            return null;
        }
        return new VoicechatConnectionImpl(player, state);
    }

    @Override
    @Nullable
    public de.maxhenkel.voicechat.api.Group getGroup() {
        return this.group;
    }

    @Override
    public boolean isInGroup() {
        return this.group != null;
    }

    @Override
    public void setGroup(@Nullable de.maxhenkel.voicechat.api.Group group) {
        Server server = Voicechat.SERVER.getServer();
        if (server == null) {
            return;
        }
        if (group == null) {
            server.getGroupManager().leaveGroup(this.serverPlayer);
            return;
        }
        if (group instanceof GroupImpl) {
            GroupImpl g = (GroupImpl)group;
            Group actualGroup = server.getGroupManager().getGroup(g.getGroup().getId());
            if (actualGroup == null) {
                server.getGroupManager().addGroup(g.getGroup(), this.serverPlayer);
                actualGroup = g.getGroup();
            }
            server.getGroupManager().joinGroup(actualGroup, this.serverPlayer, g.getGroup().getPassword());
        }
    }

    @Override
    public boolean isDisabled() {
        return this.state.isDisabled();
    }

    @Override
    public ServerPlayer getPlayer() {
        return this.player;
    }
}

