/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.config;

import de.maxhenkel.voicechat.config.ServerConfig;
import de.maxhenkel.voicechat.configbuilder.ConfigBuilder;

public class FabricServerConfig
extends ServerConfig {
    public FabricServerConfig(ConfigBuilder builder) {
        this.voiceChatPort = builder.integerEntry("port", 24454, -1, 65535);
        this.voiceChatBindAddress = builder.stringEntry("bind_address", "");
        this.voiceChatDistance = builder.doubleEntry("max_voice_distance", 48.0, 1.0, 1000000.0);
        this.crouchDistanceMultiplier = builder.doubleEntry("crouch_distance_multiplier", 1.0, 0.01, 1.0);
        this.whisperDistanceMultiplier = builder.doubleEntry("whisper_distance_multiplier", 0.5, 0.01, 1.0);
        this.voiceChatCodec = builder.enumEntry("codec", ServerConfig.Codec.VOIP);
        this.voiceChatMtuSize = builder.integerEntry("mtu_size", 1024, 256, 10000);
        this.keepAlive = builder.integerEntry("keep_alive", 1000, 1000, Integer.MAX_VALUE);
        this.groupsEnabled = builder.booleanEntry("enable_groups", true);
        this.openGroups = builder.booleanEntry("open_groups", false);
        this.voiceHost = builder.stringEntry("voice_host", "");
        this.allowRecording = builder.booleanEntry("allow_recording", true);
        this.spectatorInteraction = builder.booleanEntry("spectator_interaction", false);
        this.spectatorPlayerPossession = builder.booleanEntry("spectator_player_possession", false);
        this.forceVoiceChat = builder.booleanEntry("force_voice_chat", false);
        this.loginTimeout = builder.integerEntry("login_timeout", 10000, 100, Integer.MAX_VALUE);
        this.broadcastRange = builder.doubleEntry("broadcast_range", -1.0, -1.0, Double.MAX_VALUE);
    }
}

