/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.platform;

import fudge.notenoughcrashes.platform.CommonModMetadata;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModsByLocation {
    private final Map<String, Set<CommonModMetadata>> locationToMod;

    private static String stringify(Set<CommonModMetadata> mods) {
        return String.format("[%s]", mods.stream().map(CommonModMetadata::name).collect(Collectors.joining(",")));
    }

    public String toString() {
        return "Mods By Location: {\n" + this.locationToMod.entrySet().stream().map(kv -> "\t'" + (String)kv.getKey() + "' -> " + ModsByLocation.stringify((Set)kv.getValue())).collect(Collectors.joining(",\n")) + "\n}";
    }

    public ModsByLocation(Map<Path, Set<CommonModMetadata>> locationToMod) {
        HashMap<String, Set<CommonModMetadata>> mods = new HashMap<String, Set<CommonModMetadata>>();
        locationToMod.forEach((path, mod) -> mods.put(ModsByLocation.normalizePathString(path.toUri().toString()), (Set<CommonModMetadata>)mod));
        this.locationToMod = mods;
    }

    public Set<CommonModMetadata> get(URI path) {
        return this.locationToMod.get(ModsByLocation.normalizePathString(path.toString()));
    }

    @Nullable
    public Set<CommonModMetadata> get(Path path) {
        return this.get(path.toUri());
    }

    @NotNull
    public Set<CommonModMetadata> getOrEmpty(Path path) {
        Set<CommonModMetadata> mods = this.get(path);
        return mods != null ? mods : Collections.emptySet();
    }

    private static String normalizePathString(String path) {
        String noUnion = ModsByLocation.removePrefix(path, "union:/");
        String noScheme = ModsByLocation.removeAndBefore(noUnion, "//");
        String noPercent = ModsByLocation.removeLastPercentSymbol(noScheme);
        return ModsByLocation.removeSuffix(ModsByLocation.removeSuffix(noPercent, "/"), "!");
    }

    private static String removeLastPercentSymbol(String str) {
        int i;
        int toRemovePos = str.lastIndexOf("%");
        if (toRemovePos == -1) {
            return str;
        }
        for (i = toRemovePos + 1; i < str.length() && Character.isDigit(str.charAt(i)); ++i) {
        }
        return str.substring(0, toRemovePos) + str.substring(i);
    }

    private static String removeSuffix(String str, String suffix) {
        return str.endsWith(suffix) ? str.substring(0, str.length() - suffix.length()) : str;
    }

    private static String removePrefix(String str, String suffix) {
        return str.startsWith(suffix) ? str.substring(suffix.length()) : str;
    }

    private static String removeAndBefore(String str, String toRemove) {
        int toRemovePos = str.lastIndexOf(toRemove);
        if (toRemovePos == -1) {
            return str;
        }
        return str.substring(toRemovePos + toRemove.length());
    }

    private static String removeAndAfter(String str, String toRemove) {
        int toRemovePos = str.lastIndexOf(toRemove);
        if (toRemovePos == -1) {
            return str;
        }
        return str.substring(0, toRemovePos);
    }
}

