/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashSet;
import java.util.Set;
import net.optifine.Config;
import net.optifine.DynamicLights;

public class DynamicLight {
    private bbn entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private long timeCheckMs = 0L;
    private Set<gt> setLitChunkPos = new HashSet();
    private gt.a blockPosMutable = new gt.a();

    public DynamicLight(bbn entity) {
        this.entity = entity;
        this.offsetY = entity.cA();
    }

    public void update(ezq renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.df() - 0.5;
        double posY = this.entity.dh() - 0.5 + this.offsetY;
        double posZ = this.entity.dl() - 0.5;
        int lightLevel = DynamicLights.getLightLevel((bbn)this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        HashSet setNewPos = new HashSet();
        if (lightLevel > 0) {
            gy dirX = (ami.b((double)posX) & 0xF) >= 8 ? gy.f : gy.e;
            gy dirY = (ami.b((double)posY) & 0xF) >= 8 ? gy.b : gy.a;
            gy dirZ = (ami.b((double)posZ) & 0xF) >= 8 ? gy.d : gy.c;
            gt chunkPos = new gt(posX, posY, posZ);
            fch.c chunk = renderGlobal.getRenderChunk(chunkPos);
            gt chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            fch.c chunkX = renderGlobal.getRenderChunk(chunkPosX);
            gt chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            fch.c chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            gt chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            fch.c chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            gt chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            fch.c chunkY = renderGlobal.getRenderChunk(chunkPosY);
            gt chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            fch.c chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            gt chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            fch.c chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            gt chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            fch.c chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private gt getChunkPos(fch.c renderChunk, gt pos, gy facing) {
        if (renderChunk != null) {
            return renderChunk.a(facing);
        }
        return pos.a(facing, 16);
    }

    private void updateChunkLight(fch.c renderChunk, Set<gt> setPrevPos, Set<gt> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        fch.b compiledChunk = renderChunk.d();
        if (compiledChunk != null && !compiledChunk.a()) {
            renderChunk.a(false);
            renderChunk.setNeedsBackgroundPriorityUpdate(true);
        }
        gt pos = renderChunk.f().h();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(ezq renderGlobal) {
        for (gt posOld : this.setLitChunkPos) {
            fch.c chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public bbn getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }
}

