/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.config;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import su.plo.voice.server.config.ServerMuted;

public class ServerData {
    private static final Gson gson = new Gson();
    private final List<ServerMuted> muted;
    private final Map<UUID, Map<String, Boolean>> permissions;

    public static ServerData read() {
        File dataFile = new File("config/PlasmoVoice/server_data.json");
        if (dataFile.exists()) {
            try {
                JsonReader reader = new JsonReader((Reader)new FileReader(dataFile));
                try {
                    return (ServerData)gson.fromJson(reader, ServerData.class);
                }
                catch (JsonSyntaxException j) {
                    dataFile.delete();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return new ServerData(new ArrayList<ServerMuted>(), new HashMap<UUID, Map<String, Boolean>>());
    }

    public static void saveAsync(ServerData data) {
        new Thread(() -> {
            File configDir = new File("config/PlasmoVoice");
            configDir.mkdirs();
            try (FileWriter w = new FileWriter("config/PlasmoVoice/server_data.json");){
                w.write(gson.toJson((Object)data));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
    }

    public static void save(ServerData data) {
        File configDir = new File("config/PlasmoVoice");
        configDir.mkdirs();
        try (FileWriter w = new FileWriter("config/PlasmoVoice/server_data.json");){
            w.write(gson.toJson((Object)data));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ServerData(List<ServerMuted> muted, Map<UUID, Map<String, Boolean>> permissions) {
        this.muted = muted;
        this.permissions = permissions;
    }

    public List<ServerMuted> getMuted() {
        return this.muted;
    }

    public Map<UUID, Map<String, Boolean>> getPermissions() {
        return this.permissions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerData)) {
            return false;
        }
        ServerData other = (ServerData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ServerMuted> this$muted = this.getMuted();
        List<ServerMuted> other$muted = other.getMuted();
        if (this$muted == null ? other$muted != null : !((Object)this$muted).equals(other$muted)) {
            return false;
        }
        Map<UUID, Map<String, Boolean>> this$permissions = this.getPermissions();
        Map<UUID, Map<String, Boolean>> other$permissions = other.getPermissions();
        return !(this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ServerMuted> $muted = this.getMuted();
        result = result * 59 + ($muted == null ? 43 : ((Object)$muted).hashCode());
        Map<UUID, Map<String, Boolean>> $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        return result;
    }

    public String toString() {
        return "ServerData(muted=" + this.getMuted() + ", permissions=" + this.getPermissions() + ")";
    }
}

