/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.mixin;

import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import net.minecraft.class_1044;
import net.minecraft.class_1046;
import net.minecraft.class_1060;
import net.minecraft.class_1068;
import net.minecraft.class_1071;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import su.plo.voice.client.utils.IPlayerSkinProvider;

@Mixin(value={class_1071.class})
public class MixinSkinManager
implements IPlayerSkinProvider {
    @Shadow
    @Final
    private File field_5305;
    @Shadow
    @Final
    private class_1060 field_5304;

    @Inject(method={"registerSkins"}, at={@At(value="RETURN")})
    private void loadSkin(GameProfile profile, class_1071.class_1072 callback, boolean requireSecure, CallbackInfo ci) {
        Runnable runnable = () -> {
            try {
                URL url = new URL("https://vc.plo.su/capes/" + profile.getName() + ".png");
                MinecraftProfileTexture texture = new MinecraftProfileTexture(url.toString(), new HashMap());
                String string = Hashing.sha1().hashUnencodedChars((CharSequence)texture.getHash()).toString();
                class_2960 identifier = new class_2960("skins/" + string);
                File file = new File(this.field_5305, string.length() > 2 ? string.substring(0, 2) : "xx");
                File file2 = new File(file, string);
                if (file2.exists()) {
                    if (System.currentTimeMillis() - file2.lastModified() < 86400L) {
                        RenderSystem.recordRenderCall(() -> {
                            class_1046 playerSkinTexture = new class_1046(file2, texture.getUrl(), class_1068.method_4649(), false, () -> {
                                if (callback != null) {
                                    callback.onSkinTextureAvailable(MinecraftProfileTexture.Type.CAPE, identifier, texture);
                                }
                            });
                            this.field_5304.method_4616(identifier, (class_1044)playerSkinTexture);
                        });
                        return;
                    }
                    file2.delete();
                }
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setConnectTimeout(3000);
                connection.setReadTimeout(3000);
                connection.setUseCaches(false);
                if (connection.getResponseCode() == 200) {
                    RenderSystem.recordRenderCall(() -> {
                        class_1046 playerSkinTexture = new class_1046(file2, texture.getUrl(), class_1068.method_4649(), false, () -> {
                            if (callback != null) {
                                callback.onSkinTextureAvailable(MinecraftProfileTexture.Type.CAPE, identifier, texture);
                            }
                        });
                        this.field_5304.method_4616(identifier, (class_1044)playerSkinTexture);
                    });
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        };
        class_156.method_18349().execute(runnable);
    }

    @Override
    public File getSkinCacheDir() {
        return this.field_5305;
    }
}

