/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.common.packets.udp;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import su.plo.voice.common.packets.Packet;
import su.plo.voice.common.packets.udp.AuthPacket;
import su.plo.voice.common.packets.udp.AuthPacketAck;
import su.plo.voice.common.packets.udp.PingPacket;
import su.plo.voice.common.packets.udp.VoiceClientPacket;
import su.plo.voice.common.packets.udp.VoiceEndClientPacket;
import su.plo.voice.common.packets.udp.VoiceEndServerPacket;
import su.plo.voice.common.packets.udp.VoiceServerPacket;

public class PacketUDP {
    private final long timestamp = System.currentTimeMillis();
    private final long ttl;
    private Packet packet;
    private InetAddress address;
    private int port = -1;
    private static final Map<Byte, Class<? extends Packet>> packetRegistry = new HashMap<Byte, Class<? extends Packet>>();

    public PacketUDP(Packet packet, String secret) {
        this(packet);
    }

    public PacketUDP(Packet packet) {
        this();
        this.packet = packet;
    }

    private PacketUDP() {
        this.ttl = 2000L;
    }

    public Packet getPacket() {
        return this.packet;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getTTL() {
        return this.ttl;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    private static byte getPacketType(Packet packet) {
        for (Map.Entry<Byte, Class<? extends Packet>> entry : packetRegistry.entrySet()) {
            if (!packet.getClass().equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return -1;
    }

    public static PacketUDP read(DatagramSocket socket) throws IllegalStateException, IllegalAccessException, InstantiationException, IOException, NoSuchMethodException, InvocationTargetException {
        DatagramPacket packet = new DatagramPacket(new byte[4096], 4096);
        socket.receive(packet);
        byte[] data = new byte[packet.getLength()];
        System.arraycopy(packet.getData(), packet.getOffset(), data, 0, packet.getLength());
        ByteArrayDataInput input = ByteStreams.newDataInput((byte[])data);
        byte packetType = input.readByte();
        Class<? extends Packet> packetClass = packetRegistry.get(packetType);
        if (packetClass == null) {
            throw new InstantiationException("Could not find packet with ID " + packetType);
        }
        Packet p = packetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        PacketUDP message = new PacketUDP();
        message.address = packet.getAddress();
        message.port = packet.getPort();
        p.read(input);
        message.packet = p;
        return message;
    }

    public static byte[] write(Packet packet) throws IOException {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        byte type = PacketUDP.getPacketType(packet);
        if (type < 0) {
            throw new IllegalArgumentException("Packet type not found");
        }
        out.writeByte((int)type);
        packet.write(out);
        return out.toByteArray();
    }

    static {
        packetRegistry.put((byte)0, VoiceClientPacket.class);
        packetRegistry.put((byte)1, VoiceServerPacket.class);
        packetRegistry.put((byte)2, AuthPacket.class);
        packetRegistry.put((byte)3, AuthPacketAck.class);
        packetRegistry.put((byte)4, VoiceEndClientPacket.class);
        packetRegistry.put((byte)5, VoiceEndServerPacket.class);
        packetRegistry.put((byte)6, PingPacket.class);
    }
}

