/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.sound.capture;

import org.lwjgl.openal.ALC11;
import su.plo.voice.client.VoiceClient;
import su.plo.voice.client.sound.VolumeAdjuster;
import su.plo.voice.client.sound.capture.CaptureDevice;
import su.plo.voice.client.sound.openal.AlUtil;
import su.plo.voice.client.sound.openal.CustomSoundEngine;
import su.plo.voice.client.utils.AudioUtils;

public class AlCaptureDevice
implements CaptureDevice {
    private long pointer;
    private boolean started;
    private final VolumeAdjuster adjuster = new VolumeAdjuster();

    @Override
    public void open() throws IllegalStateException {
        if (this.isOpen()) {
            throw new IllegalStateException("Capture device already open");
        }
        this.pointer = CustomSoundEngine.openCaptureDevice();
    }

    @Override
    public void start() {
        if (!this.isOpen() || this.started) {
            return;
        }
        ALC11.alcCaptureStart((long)this.pointer);
        AlUtil.checkErrors("Start capture device");
        this.started = true;
    }

    @Override
    public void stop() {
        if (!this.isOpen() || !this.started) {
            return;
        }
        ALC11.alcCaptureStop((long)this.pointer);
        AlUtil.checkErrors("Stop capture device");
        this.started = false;
        int available = this.available();
        short[] data = new short[available];
        ALC11.alcCaptureSamples((long)this.pointer, (short[])data, (int)data.length);
        AlUtil.checkErrors("Capture available samples");
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.stop();
        ALC11.alcCaptureCloseDevice((long)this.pointer);
        AlUtil.checkErrors("Close capture device");
        this.pointer = 0L;
    }

    public int available() {
        int samples = ALC11.alcGetInteger((long)this.pointer, (int)786);
        AlUtil.checkErrors("Get available samples count");
        return samples;
    }

    @Override
    public byte[] read(int frameSize) {
        if (frameSize / 2 > this.available()) {
            return null;
        }
        short[] shorts = new short[frameSize / 2];
        ALC11.alcCaptureSamples((long)this.pointer, (short[])shorts, (int)shorts.length);
        AlUtil.checkErrors("Capture samples");
        this.adjuster.adjust(shorts, ((Double)VoiceClient.getClientConfig().microphoneAmplification.get()).floatValue());
        return AudioUtils.shortsToBytes(shorts);
    }

    @Override
    public boolean isOpen() {
        return this.pointer != 0L;
    }
}

