/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.sound;

import su.plo.voice.client.VoiceClient;
import su.plo.voice.client.sound.Limiter;
import su.plo.voice.client.sound.Recorder;
import su.plo.voice.client.utils.AudioUtils;

public class Compressor {
    private static final float compressorSlope = 0.9f;
    private static final float outputGain = AudioUtils.dbToMul(0.0f);
    private static final float attackTime = 6.0f;
    private static final float releaseTime = 60.0f;
    private final Limiter limiter = new Limiter();
    private float[] envelopeBuf = new float[0];
    private float envelope;

    public synchronized byte[] compress(byte[] audio) {
        float[] audioFloats = AudioUtils.bytesToFloats(audio);
        this.analyzeEnvelope(audioFloats);
        this.process(audioFloats);
        this.limiter.limit(audioFloats);
        return AudioUtils.floatsToBytes(audioFloats);
    }

    private synchronized void analyzeEnvelope(float[] samples) {
        this.envelopeBuf = new float[samples.length];
        float attackGain = AudioUtils.gainCoefficient(Recorder.getSampleRate(), 0.006f);
        float releaseGain = AudioUtils.gainCoefficient(Recorder.getSampleRate(), 0.06f);
        float env = this.envelope;
        for (int i = 0; i < samples.length; ++i) {
            float envIn = Math.abs(samples[i]);
            env = env < envIn ? envIn + attackGain * (env - envIn) : envIn + releaseGain * (env - envIn);
            this.envelopeBuf[i] = Math.max(this.envelopeBuf[i], env);
        }
        this.envelope = this.envelopeBuf[samples.length - 1];
    }

    private synchronized void process(float[] samples) {
        float compressorThreshold = ((Integer)VoiceClient.getClientConfig().compressorThreshold.get()).intValue();
        int i = 0;
        while (i < samples.length) {
            float envDB = AudioUtils.mulToDB(this.envelopeBuf[i]);
            float compressorGain = 0.9f * (compressorThreshold - envDB);
            compressorGain = AudioUtils.dbToMul(Math.min(0.0f, compressorGain));
            int n = i++;
            samples[n] = samples[n] * (compressorGain * outputGain);
        }
    }
}

