/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client;

import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import su.plo.voice.client.config.ClientConfig;
import su.plo.voice.client.config.ServerSettings;
import su.plo.voice.client.gui.PlayerVolumeHandler;
import su.plo.voice.client.gui.VoiceSettingsScreen;
import su.plo.voice.client.socket.SocketClientUDPQueue;
import su.plo.voice.client.socket.SocketConnection;
import su.plo.voice.client.sound.AbstractSoundQueue;
import su.plo.voice.client.sound.Recorder;
import su.plo.voice.client.sound.openal.CustomSoundEngine;

public abstract class VoiceClient {
    private static VoiceClient instance;
    public static final class_2960 PLASMO_VOICE;
    public static final String PROTOCOL_VERSION = "1.0.0";
    public static final Logger LOGGER;
    public static final UUID NIL_UUID;
    private static ClientConfig clientConfig;
    private static ClientConfig.ConfigKeyBindings keyBindings;
    private static ServerSettings serverConfig;
    public static SocketConnection socketUDP;
    public static Recorder recorder;
    public static final CustomSoundEngine soundEngine;
    private static boolean speaking;
    private static boolean speakingPriority;
    public static class_304 menuKey;
    public static final class_2960 ICONS;

    public void initialize() {
        instance = this;
        class_310 minecraft = class_310.method_1551();
        clientConfig = ClientConfig.read();
        keyBindings = VoiceClient.clientConfig.keyBindings;
        recorder = new Recorder();
        ((ClientConfig.KeyBinding)VoiceClient.keyBindings.action.get()).setOnPress(PlayerVolumeHandler::onButton);
        ((ClientConfig.KeyBinding)VoiceClient.keyBindings.muteMicrophone.get()).setOnPress(action -> {
            if (action == 1) {
                VoiceClient.clientConfig.microphoneMuted.invert();
            }
        });
        ((ClientConfig.KeyBinding)VoiceClient.keyBindings.muteChat.get()).setOnPress(action -> {
            if (action == 1) {
                VoiceClient.clientConfig.speakerMuted.invert();
            }
        });
        ((ClientConfig.KeyBinding)VoiceClient.keyBindings.increaseDistance.get()).setOnPress(action -> {
            if (action == 1 && minecraft.field_1724 != null && VoiceClient.isConnected() && clientConfig.getServers().containsKey(VoiceClient.getServerConfig().getIp())) {
                ClientConfig.ServerConfig serverConfig = clientConfig.getServers().get(VoiceClient.getServerConfig().getIp());
                int index = (VoiceClient.getServerConfig().getDistances().indexOf(serverConfig.distance.get()) + 1) % VoiceClient.getServerConfig().getDistances().size();
                int value = VoiceClient.getServerConfig().getDistances().get(index);
                serverConfig.distance.set(value);
                VoiceClient.getServerConfig().setDistance((short)value);
                minecraft.field_1705.method_1758((class_2561)class_2561.method_43469((String)"message.plasmo_voice.distance_changed", (Object[])new Object[]{value}), false);
            }
        });
        ((ClientConfig.KeyBinding)VoiceClient.keyBindings.decreaseDistance.get()).setOnPress(action -> {
            if (action == 1 && minecraft.field_1724 != null && VoiceClient.isConnected() && clientConfig.getServers().containsKey(VoiceClient.getServerConfig().getIp())) {
                ClientConfig.ServerConfig serverConfig = clientConfig.getServers().get(VoiceClient.getServerConfig().getIp());
                int index = VoiceClient.getServerConfig().getDistances().indexOf(serverConfig.distance.get()) - 1;
                if (index < 0) {
                    index = VoiceClient.getServerConfig().getDistances().size() - 1;
                }
                int value = VoiceClient.getServerConfig().getDistances().get(index);
                serverConfig.distance.set(value);
                VoiceClient.getServerConfig().setDistance((short)value);
                minecraft.field_1705.method_1758((class_2561)class_2561.method_43469((String)"message.plasmo_voice.distance_changed", (Object[])new Object[]{value}), false);
            }
        });
        ((ClientConfig.KeyBinding)VoiceClient.keyBindings.occlusion.get()).setOnPress(action -> {
            if (action == 1 && minecraft.field_1724 != null && !soundEngine.isSoundPhysics() && VoiceClient.isConnected()) {
                VoiceClient.clientConfig.occlusion.invert();
                if (((Boolean)VoiceClient.clientConfig.occlusion.get()).booleanValue()) {
                    minecraft.field_1705.method_1758((class_2561)class_2561.method_43469((String)"message.plasmo_voice.occlusion_changed", (Object[])new Object[]{class_2561.method_43471((String)"gui.plasmo_voice.on")}), false);
                } else {
                    minecraft.field_1705.method_1758((class_2561)class_2561.method_43469((String)"message.plasmo_voice.occlusion_changed", (Object[])new Object[]{class_2561.method_43471((String)"gui.plasmo_voice.off")}), false);
                }
            }
        });
    }

    public static void disconnect() {
        if (socketUDP != null) {
            socketUDP.close();
        }
        recorder.close(true);
        serverConfig = null;
        SocketClientUDPQueue.talking.clear();
        SocketClientUDPQueue.audioChannels.values().forEach(AbstractSoundQueue::closeAndKill);
        SocketClientUDPQueue.audioChannels.clear();
    }

    public static boolean isMicrophoneLoopback() {
        VoiceSettingsScreen screen;
        class_437 class_4372 = class_310.method_1551().field_1755;
        return class_4372 instanceof VoiceSettingsScreen && (screen = (VoiceSettingsScreen)class_4372).getSource() != null;
    }

    public static boolean isSettingsOpen() {
        return class_310.method_1551().field_1755 instanceof VoiceSettingsScreen;
    }

    public static boolean isConnected() {
        return socketUDP != null && serverConfig != null && socketUDP.isConnected();
    }

    public abstract String getVersion();

    public static VoiceClient getInstance() {
        return instance;
    }

    public static ClientConfig getClientConfig() {
        return clientConfig;
    }

    public static ClientConfig.ConfigKeyBindings getKeyBindings() {
        return keyBindings;
    }

    public static void setServerConfig(ServerSettings serverConfig) {
        VoiceClient.serverConfig = serverConfig;
    }

    public static ServerSettings getServerConfig() {
        return serverConfig;
    }

    public static CustomSoundEngine getSoundEngine() {
        return soundEngine;
    }

    public static void setSpeaking(boolean speaking) {
        VoiceClient.speaking = speaking;
    }

    public static boolean isSpeaking() {
        return speaking;
    }

    public static void setSpeakingPriority(boolean speakingPriority) {
        VoiceClient.speakingPriority = speakingPriority;
    }

    public static boolean isSpeakingPriority() {
        return speakingPriority;
    }

    static {
        PLASMO_VOICE = new class_2960("plasmo:voice");
        LOGGER = LogManager.getLogger((String)"Plasmo Voice");
        NIL_UUID = new UUID(0L, 0L);
        soundEngine = new CustomSoundEngine();
        speaking = false;
        speakingPriority = false;
        ICONS = new class_2960("plasmo_voice", "textures/gui/icons.png");
    }
}

