/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl.gui.controllers;

import dev.isxander.yacl.api.Controller;
import dev.isxander.yacl.api.utils.Dimension;
import dev.isxander.yacl.gui.AbstractWidget;
import dev.isxander.yacl.gui.YACLScreen;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5489;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public abstract class ControllerWidget<T extends Controller<?>>
extends AbstractWidget {
    protected final T control;
    protected class_5489 wrappedTooltip;
    protected final YACLScreen screen;
    protected boolean focused = false;
    protected boolean hovered = false;
    protected final class_2561 modifiedOptionName;
    protected final String optionNameString;

    public ControllerWidget(T control, YACLScreen screen, Dimension<Integer> dim) {
        super(dim);
        this.control = control;
        this.screen = screen;
        control.option().addListener((opt, pending) -> this.updateTooltip());
        this.updateTooltip();
        this.modifiedOptionName = control.option().name().method_27661().method_27692(class_124.field_1056);
        this.optionNameString = control.option().name().getString().toLowerCase();
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.hovered = this.method_25405(mouseX, mouseY);
        class_2561 name = this.control.option().changed() ? this.modifiedOptionName : this.control.option().name();
        Object nameString = name.getString();
        boolean firstIter = true;
        while (this.textRenderer.method_1727((String)nameString) > (Integer)this.dim.width() - this.getControlWidth() - this.getXPadding() - 7) {
            nameString = ((String)nameString).substring(0, Math.max(((String)nameString).length() - (firstIter ? 2 : 5), 0)).trim();
            nameString = (String)nameString + "...";
            firstIter = false;
        }
        class_5250 shortenedName = class_2561.method_43470((String)nameString).method_27696(name.method_10866());
        this.drawButtonRect(matrices, (Integer)this.dim.x(), (Integer)this.dim.y(), (Integer)this.dim.xLimit(), (Integer)this.dim.yLimit(), this.isHovered(), this.isAvailable());
        matrices.method_22903();
        matrices.method_22904((double)((Integer)this.dim.x() + this.getXPadding()), (double)this.getTextY(), 0.0);
        this.textRenderer.method_30881(matrices, (class_2561)shortenedName, 0.0f, 0.0f, this.getValueColor());
        matrices.method_22909();
        this.drawValueText(matrices, mouseX, mouseY, delta);
        if (this.isHovered()) {
            this.drawHoveredControl(matrices, mouseX, mouseY, delta);
        }
    }

    @Override
    public void postRender(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.hovered) {
            YACLScreen.renderMultilineTooltip(matrices, this.textRenderer, this.wrappedTooltip, (Integer)this.dim.centerX(), (Integer)this.dim.y() - 5, (Integer)this.dim.yLimit() + 5, this.screen.field_22789, this.screen.field_22790);
        }
    }

    protected void drawHoveredControl(class_4587 matrices, int mouseX, int mouseY, float delta) {
    }

    protected void drawValueText(class_4587 matrices, int mouseX, int mouseY, float delta) {
        class_2561 valueText = this.getValueText();
        matrices.method_22903();
        matrices.method_22904((double)((Integer)this.dim.xLimit() - this.textRenderer.method_27525((class_5348)valueText) - this.getXPadding()), (double)this.getTextY(), 0.0);
        this.textRenderer.method_30881(matrices, valueText, 0.0f, 0.0f, this.getValueColor());
        matrices.method_22909();
    }

    public boolean method_25405(double mouseX, double mouseY) {
        if (this.dim == null) {
            return false;
        }
        return this.dim.isPointInside((int)mouseX, (int)mouseY);
    }

    private void updateTooltip() {
        this.wrappedTooltip = class_5489.method_30890((class_327)this.textRenderer, (class_5348)this.control.option().tooltip(), (int)(this.screen.field_22789 / 3 * 2 - 10));
    }

    protected int getControlWidth() {
        return this.isHovered() ? this.getHoveredControlWidth() : this.getUnhoveredControlWidth();
    }

    public boolean isHovered() {
        return this.isAvailable() && (this.hovered || this.focused);
    }

    protected abstract int getHoveredControlWidth();

    protected int getUnhoveredControlWidth() {
        return this.textRenderer.method_27525((class_5348)this.getValueText());
    }

    protected int getXPadding() {
        return 5;
    }

    protected int getYPadding() {
        return 2;
    }

    protected class_2561 getValueText() {
        return this.control.formatValue();
    }

    protected boolean isAvailable() {
        return this.control.option().available();
    }

    protected int getValueColor() {
        return this.isAvailable() ? -1 : -6250336;
    }

    protected void drawOutline(class_4587 matrices, int x1, int y1, int x2, int y2, int width, int color) {
        class_332.method_25294((class_4587)matrices, (int)x1, (int)y1, (int)x2, (int)(y1 + width), (int)color);
        class_332.method_25294((class_4587)matrices, (int)x2, (int)y1, (int)(x2 - width), (int)y2, (int)color);
        class_332.method_25294((class_4587)matrices, (int)x1, (int)y2, (int)x2, (int)(y2 - width), (int)color);
        class_332.method_25294((class_4587)matrices, (int)x1, (int)y1, (int)(x1 + width), (int)y2, (int)color);
    }

    protected float getTextY() {
        float f = (float)((Integer)this.dim.y()).intValue() + (float)((Integer)this.dim.height()).intValue() / 2.0f;
        Objects.requireNonNull(this.textRenderer);
        return f - 9.0f / 2.0f;
    }

    public boolean method_25407(boolean lookForwards) {
        if (!this.isAvailable()) {
            return false;
        }
        this.focused = !this.focused;
        return this.focused;
    }

    @Override
    public void unfocus() {
        this.focused = false;
    }

    @Override
    public boolean matchesSearch(String query) {
        return this.optionNameString.contains(query.toLowerCase());
    }

    @Override
    public class_6379.class_6380 method_37018() {
        return this.focused ? class_6379.class_6380.field_33786 : (this.isHovered() ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784);
    }

    @Override
    public void method_37020(class_6382 builder) {
    }
}

