/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl.api;

import dev.isxander.yacl.api.Controller;
import dev.isxander.yacl.api.Option;
import dev.isxander.yacl.gui.YACLScreen;
import dev.isxander.yacl.impl.ButtonOptionImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public interface ButtonOption
extends Option<BiConsumer<YACLScreen, ButtonOption>> {
    public BiConsumer<YACLScreen, ButtonOption> action();

    public static Builder createBuilder() {
        return new Builder();
    }

    public static class Builder {
        private class_2561 name;
        private final List<class_2561> tooltipLines = new ArrayList<class_2561>();
        private boolean available = true;
        private Function<ButtonOption, Controller<BiConsumer<YACLScreen, ButtonOption>>> controlGetter;
        private BiConsumer<YACLScreen, ButtonOption> action;

        private Builder() {
        }

        public Builder name(@NotNull class_2561 name) {
            Validate.notNull((Object)name, (String)"`name` cannot be null", (Object[])new Object[0]);
            this.name = name;
            return this;
        }

        public Builder tooltip(class_2561 ... tooltips) {
            Validate.notNull((Object)tooltips, (String)"`tooltips` cannot be empty", (Object[])new Object[0]);
            this.tooltipLines.addAll(List.of(tooltips));
            return this;
        }

        public Builder action(@NotNull BiConsumer<YACLScreen, ButtonOption> action) {
            Validate.notNull(action, (String)"`action` cannot be null", (Object[])new Object[0]);
            this.action = action;
            return this;
        }

        @Deprecated
        public Builder action(@NotNull Consumer<YACLScreen> action) {
            Validate.notNull(action, (String)"`action` cannot be null", (Object[])new Object[0]);
            this.action = (screen, button) -> action.accept((YACLScreen)((Object)screen));
            return this;
        }

        public Builder available(boolean available) {
            this.available = available;
            return this;
        }

        public Builder controller(@NotNull Function<ButtonOption, Controller<BiConsumer<YACLScreen, ButtonOption>>> control) {
            Validate.notNull(control, (String)"`control` cannot be null", (Object[])new Object[0]);
            this.controlGetter = control;
            return this;
        }

        public ButtonOption build() {
            Validate.notNull((Object)this.name, (String)"`name` must not be null when building `Option`", (Object[])new Object[0]);
            Validate.notNull(this.controlGetter, (String)"`control` must not be null when building `Option`", (Object[])new Object[0]);
            Validate.notNull(this.action, (String)"`action` must not be null when building `Option`", (Object[])new Object[0]);
            class_5250 concatenatedTooltip = class_2561.method_43473();
            boolean first = true;
            for (class_2561 line : this.tooltipLines) {
                if (!first) {
                    concatenatedTooltip.method_27693("\n");
                }
                first = false;
                concatenatedTooltip.method_10852(line);
            }
            return new ButtonOptionImpl(this.name, (class_2561)concatenatedTooltip, this.action, this.available, this.controlGetter);
        }
    }
}

