/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntity;
import net.optifine.RandomEntityContext;
import net.optifine.RandomEntityProperties;
import net.optifine.RandomTileEntity;
import net.optifine.reflect.ReflectorRaw;
import net.optifine.util.ArrayUtils;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class RandomEntities {
    private static Map<String, RandomEntityProperties<abb>> mapProperties = new HashMap();
    private static Map<String, RandomEntityProperties<abb>> mapSpriteProperties = new HashMap();
    private static boolean active = false;
    private static fej entityRenderDispatcher;
    private static RandomEntity randomEntity;
    private static fbo tileEntityRendererDispatcher;
    private static RandomTileEntity randomTileEntity;
    private static boolean working;
    public static final String SUFFIX_PNG = ".png";
    public static final String SUFFIX_PROPERTIES = ".properties";
    public static final String SEPARATOR_DIGITS = ".";
    public static final String PREFIX_TEXTURES_ENTITY = "textures/entity/";
    public static final String PREFIX_TEXTURES_PAINTING = "textures/painting/";
    public static final String PREFIX_TEXTURES = "textures/";
    public static final String PREFIX_OPTIFINE_RANDOM = "optifine/random/";
    public static final String PREFIX_OPTIFINE = "optifine/";
    public static final String PREFIX_OPTIFINE_MOB = "optifine/mob/";
    private static final String[] DEPENDANT_SUFFIXES;
    private static final String PREFIX_DYNAMIC_TEXTURE_HORSE = "horse/";
    private static final String[] HORSE_TEXTURES;
    private static final String[] HORSE_TEXTURES_ABBR;

    public static void entityLoaded(bbn entity, cgx world) {
        if (world == null) {
            return;
        }
        aam edm = entity.ai();
        edm.spawnPosition = entity.da();
        edm.spawnBiome = (cht)world.w(edm.spawnPosition).a();
        if (entity instanceof bob) {
            bob esr = (bob)entity;
            RandomEntities.checkEntityShoulder((bob)esr, (boolean)false);
        }
    }

    public static void entityUnloaded(bbn entity, cgx world) {
        if (entity instanceof bob) {
            bob esr = (bob)entity;
            RandomEntities.checkEntityShoulder((bob)esr, (boolean)true);
        }
    }

    public static void checkEntityShoulder(bob entity, boolean attach) {
        bcc owner = entity.fK();
        if (owner == null) {
            owner = Config.getMinecraft().t;
        }
        if (!(owner instanceof eyt)) {
            return;
        }
        eyt player = (eyt)owner;
        UUID entityUuid = entity.co();
        if (attach) {
            pj nbtRight;
            player.lastAttachedEntity = entity;
            pj nbtLeft = player.fS();
            if (nbtLeft != null && nbtLeft.e("UUID") && Config.equals((Object)nbtLeft.a("UUID"), (Object)entityUuid)) {
                player.entityShoulderLeft = entity;
                player.lastAttachedEntity = null;
            }
            if ((nbtRight = player.fT()) != null && nbtRight.e("UUID") && Config.equals((Object)nbtRight.a("UUID"), (Object)entityUuid)) {
                player.entityShoulderRight = entity;
                player.lastAttachedEntity = null;
            }
        } else {
            aam edm = entity.ai();
            if (player.entityShoulderLeft != null && Config.equals((Object)player.entityShoulderLeft.co(), (Object)entityUuid)) {
                aam edmShoulderLeft = player.entityShoulderLeft.ai();
                edm.spawnPosition = edmShoulderLeft.spawnPosition;
                edm.spawnBiome = edmShoulderLeft.spawnBiome;
                player.entityShoulderLeft = null;
            }
            if (player.entityShoulderRight != null && Config.equals((Object)player.entityShoulderRight.co(), (Object)entityUuid)) {
                aam edmShoulderRight = player.entityShoulderRight.ai();
                edm.spawnPosition = edmShoulderRight.spawnPosition;
                edm.spawnBiome = edmShoulderRight.spawnBiome;
                player.entityShoulderRight = null;
            }
        }
    }

    public static void worldChanged(cgx oldWorld, cgx newWorld) {
        if (newWorld instanceof euv) {
            euv newWorldClient = (euv)newWorld;
            Iterable entities = newWorldClient.e();
            for (bbn entity : entities) {
                RandomEntities.entityLoaded((bbn)entity, (cgx)newWorld);
            }
        }
        randomEntity.setEntity(null);
        randomTileEntity.setTileEntity(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static abb getTextureLocation(abb loc) {
        if (!active) {
            return loc;
        }
        IRandomEntity re = RandomEntities.getRandomEntityRendered();
        if (re == null) {
            return loc;
        }
        if (working) {
            return loc;
        }
        try {
            working = true;
            String name = loc.a();
            if (name.startsWith("horse/")) {
                name = RandomEntities.getHorseTexturePath((String)name, (int)"horse/".length());
            }
            if (!name.startsWith("textures/entity/") && !name.startsWith("textures/painting/")) {
                abb abb2 = loc;
                return abb2;
            }
            RandomEntityProperties props = (RandomEntityProperties)mapProperties.get(name);
            if (props == null) {
                abb abb3 = loc;
                return abb3;
            }
            abb abb4 = (abb)props.getResource(re, (Object)loc);
            return abb4;
        }
        finally {
            working = false;
        }
    }

    private static String getHorseTexturePath(String path, int pos) {
        if (HORSE_TEXTURES == null || HORSE_TEXTURES_ABBR == null) {
            return path;
        }
        for (int i2 = 0; i2 < HORSE_TEXTURES_ABBR.length; ++i2) {
            String abbr = HORSE_TEXTURES_ABBR[i2];
            if (!path.startsWith(abbr, pos)) continue;
            return HORSE_TEXTURES[i2];
        }
        return path;
    }

    public static IRandomEntity getRandomEntityRendered() {
        if (entityRenderDispatcher.getRenderedEntity() != null) {
            randomEntity.setEntity(entityRenderDispatcher.getRenderedEntity());
            return randomEntity;
        }
        if (fbo.tileEntityRendered != null) {
            cti te2 = fbo.tileEntityRendered;
            if (te2.k() != null) {
                randomTileEntity.setTileEntity(te2);
                return randomTileEntity;
            }
        }
        return null;
    }

    public static IRandomEntity getRandomEntity(bbn entityIn) {
        randomEntity.setEntity(entityIn);
        return randomEntity;
    }

    public static IRandomEntity getRandomBlockEntity(cti tileEntityIn) {
        randomTileEntity.setTileEntity(tileEntityIn);
        return randomTileEntity;
    }

    private static RandomEntityProperties<abb> makeProperties(abb loc, RandomEntityContext.Textures context) {
        RandomEntityProperties props;
        String path = loc.a();
        abb locProps = RandomEntities.getLocationProperties((abb)loc, (boolean)context.isLegacy());
        if (locProps != null && (props = RandomEntityProperties.parse((abb)locProps, (abb)loc, (RandomEntityContext)context)) != null) {
            return props;
        }
        int[] variants = RandomEntities.getLocationsVariants((abb)loc, (boolean)context.isLegacy(), (RandomEntityContext)context);
        if (variants == null) {
            return null;
        }
        return new RandomEntityProperties(path, loc, variants, (RandomEntityContext)context);
    }

    private static abb getLocationProperties(abb loc, boolean legacy) {
        String path;
        String pathBase;
        String pathProps;
        abb locMcp = RandomEntities.getLocationRandom((abb)loc, (boolean)legacy);
        if (locMcp == null) {
            return null;
        }
        String domain = locMcp.b();
        abb locProps = new abb(domain, pathProps = (pathBase = StrUtils.removeSuffix((String)(path = locMcp.a()), (String)".png")) + ".properties");
        if (Config.hasResource((abb)locProps)) {
            return locProps;
        }
        String pathParent = RandomEntities.getParentTexturePath((String)pathBase);
        if (pathParent == null) {
            return null;
        }
        abb locParentProps = new abb(domain, pathParent + ".properties");
        if (Config.hasResource((abb)locParentProps)) {
            return locParentProps;
        }
        return null;
    }

    protected static abb getLocationRandom(abb loc, boolean legacy) {
        String domain = loc.b();
        String path = loc.a();
        if (path.startsWith("optifine/")) {
            return loc;
        }
        String prefixTextures = "textures/";
        String prefixRandom = "optifine/random/";
        if (legacy) {
            prefixTextures = "textures/entity/";
            prefixRandom = "optifine/mob/";
        }
        if (!path.startsWith(prefixTextures)) {
            return null;
        }
        String pathRandom = StrUtils.replacePrefix((String)path, (String)prefixTextures, (String)prefixRandom);
        return new abb(domain, pathRandom);
    }

    private static String getPathBase(String pathRandom) {
        if (pathRandom.startsWith("optifine/random/")) {
            return StrUtils.replacePrefix((String)pathRandom, (String)"optifine/random/", (String)"textures/");
        }
        if (pathRandom.startsWith("optifine/mob/")) {
            return StrUtils.replacePrefix((String)pathRandom, (String)"optifine/mob/", (String)"textures/entity/");
        }
        return null;
    }

    protected static abb getLocationIndexed(abb loc, int index) {
        if (loc == null) {
            return null;
        }
        String path = loc.a();
        int pos = path.lastIndexOf(46);
        if (pos < 0) {
            return null;
        }
        String prefix = path.substring(0, pos);
        String suffix = path.substring(pos);
        String separator = StrUtils.endsWithDigit((String)prefix) ? "." : "";
        String pathNew = prefix + separator + index + suffix;
        abb locNew = new abb(loc.b(), pathNew);
        return locNew;
    }

    private static String getParentTexturePath(String path) {
        for (int i2 = 0; i2 < DEPENDANT_SUFFIXES.length; ++i2) {
            String suffix = DEPENDANT_SUFFIXES[i2];
            if (!path.endsWith(suffix)) continue;
            String pathParent = StrUtils.removeSuffix((String)path, (String)suffix);
            return pathParent;
        }
        return null;
    }

    public static int[] getLocationsVariants(abb loc, boolean legacy, RandomEntityContext context) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        abb locRandom = RandomEntities.getLocationRandom((abb)loc, (boolean)legacy);
        if (locRandom == null) {
            return null;
        }
        for (int i2 = 1; i2 < list.size() + 10; ++i2) {
            int index = i2 + 1;
            abb locIndex = RandomEntities.getLocationIndexed((abb)locRandom, (int)index);
            if (!Config.hasResource((abb)locIndex)) continue;
            list.add(index);
        }
        if (list.size() <= 1) {
            return null;
        }
        Integer[] arr = list.toArray(new Integer[list.size()]);
        int[] intArr = ArrayUtils.toPrimitive((Integer[])arr);
        Config.dbg((String)(context.getName() + ": " + loc.a() + ", variants: " + intArr.length));
        return intArr;
    }

    public static void update() {
        entityRenderDispatcher = Config.getEntityRenderDispatcher();
        tileEntityRendererDispatcher = efu.I().ah();
        mapProperties.clear();
        mapSpriteProperties.clear();
        active = false;
        if (!Config.isRandomEntities()) {
            return;
        }
        RandomEntities.initialize();
    }

    private static void initialize() {
        String[] prefixes = new String[]{"optifine/random/", "optifine/mob/"};
        String[] suffixes = new String[]{".png", ".properties"};
        String[] pathsRandom = ResUtils.collectFiles((String[])prefixes, (String[])suffixes);
        HashSet<String> basePathsChecked = new HashSet<String>();
        for (int i2 = 0; i2 < pathsRandom.length; ++i2) {
            RandomEntityProperties props;
            Object path = pathsRandom[i2];
            path = StrUtils.removeSuffix((String)path, (String[])suffixes);
            path = StrUtils.trimTrailing((String)path, (String)"0123456789");
            path = StrUtils.removeSuffix((String)path, (String)".");
            String pathBase = RandomEntities.getPathBase((String)(path = (String)path + ".png"));
            if (basePathsChecked.contains(pathBase)) continue;
            basePathsChecked.add(pathBase);
            abb locBase = new abb(pathBase);
            if (!Config.hasResource((abb)locBase) || (props = (RandomEntityProperties)mapProperties.get(pathBase)) != null) continue;
            props = RandomEntities.makeProperties((abb)locBase, (RandomEntityContext.Textures)new RandomEntityContext.Textures(false));
            if (props == null) {
                props = RandomEntities.makeProperties((abb)locBase, (RandomEntityContext.Textures)new RandomEntityContext.Textures(true));
            }
            if (props == null) continue;
            mapProperties.put(pathBase, props);
        }
        active = !mapProperties.isEmpty();
    }

    public static synchronized void registerMaterials(Set<flt> setMaterials) {
        if (mapProperties.isEmpty()) {
            return;
        }
        HashSet<flt> newMaterials = new HashSet<flt>();
        for (flt mat : setMaterials) {
            List locs;
            abb loc = mat.b();
            String pathFull = "textures/" + loc.a() + ".png";
            RandomEntityProperties props = (RandomEntityProperties)mapProperties.get(pathFull);
            if (props == null || (locs = props.getAllResources()) == null) continue;
            for (int i2 = 0; i2 < locs.size(); ++i2) {
                abb propLoc = (abb)locs.get(i2);
                abb locSprite = TextureUtils.getSpriteLocation((abb)propLoc);
                flt spriteMat = new flt(mat.a(), locSprite);
                newMaterials.add(spriteMat);
                mapSpriteProperties.put(locSprite.a(), props);
            }
        }
        setMaterials.addAll(newMaterials);
    }

    public static synchronized void registerSprites(Set<abb> spriteLocations) {
        if (mapProperties.isEmpty()) {
            return;
        }
        HashSet<abb> newLocations = new HashSet<abb>();
        for (abb loc : spriteLocations) {
            List locs;
            String pathFull = "textures/" + loc.a() + ".png";
            RandomEntityProperties props = (RandomEntityProperties)mapProperties.get(pathFull);
            if (props == null || (locs = props.getAllResources()) == null) continue;
            for (int i2 = 0; i2 < locs.size(); ++i2) {
                abb propLoc = (abb)locs.get(i2);
                abb locSprite = TextureUtils.getSpriteLocation((abb)propLoc);
                newLocations.add(locSprite);
                mapSpriteProperties.put(locSprite.a(), props);
            }
        }
        spriteLocations.addAll(newLocations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static fke getRandomSprite(fke spriteIn) {
        if (!active) {
            return spriteIn;
        }
        IRandomEntity re = RandomEntities.getRandomEntityRendered();
        if (re == null) {
            return spriteIn;
        }
        if (working) {
            return spriteIn;
        }
        try {
            fke sprite;
            working = true;
            abb locSpriteIn = spriteIn.l();
            String name = locSpriteIn.a();
            RandomEntityProperties props = (RandomEntityProperties)mapSpriteProperties.get(name);
            if (props == null) {
                fke fke2 = spriteIn;
                return fke2;
            }
            abb loc = (abb)props.getResource(re, (Object)locSpriteIn);
            if (loc == locSpriteIn) {
                fke fke3 = spriteIn;
                return fke3;
            }
            abb locSprite = TextureUtils.getSpriteLocation((abb)loc);
            fke fke4 = sprite = spriteIn.m().a(locSprite);
            return fke4;
        }
        finally {
            working = false;
        }
    }

    public static void dbg(String str) {
        Config.dbg((String)("RandomEntities: " + str));
    }

    public static void warn(String str) {
        Config.warn((String)("RandomEntities: " + str));
    }

    static {
        randomEntity = new RandomEntity();
        randomTileEntity = new RandomTileEntity();
        working = false;
        DEPENDANT_SUFFIXES = new String[]{"_armor", "_eyes", "_exploding", "_shooting", "_fur", "_eyes", "_invulnerable", "_angry", "_tame", "_collar"};
        HORSE_TEXTURES = (String[])ReflectorRaw.getFieldValue(null, bpc.class, String[].class, (int)0);
        HORSE_TEXTURES_ABBR = (String[])ReflectorRaw.getFieldValue(null, bpc.class, String[].class, (int)1);
    }
}

