/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl.gui.controllers;

import dev.isxander.yacl.api.Controller;
import dev.isxander.yacl.api.NameableEnum;
import dev.isxander.yacl.api.Option;
import dev.isxander.yacl.api.utils.Dimension;
import dev.isxander.yacl.gui.AbstractWidget;
import dev.isxander.yacl.gui.YACLScreen;
import dev.isxander.yacl.gui.controllers.ControllerWidget;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_7291;

public class EnumController<T extends Enum<T>>
implements Controller<T> {
    private final Option<T> option;
    private final Function<T, class_2561> valueFormatter;
    private final T[] availableValues;

    public static <T extends Enum<T>> Function<T, class_2561> getDefaultFormatter() {
        return value -> {
            if (value instanceof NameableEnum) {
                NameableEnum nameableEnum = (NameableEnum)((Object)value);
                return nameableEnum.getDisplayName();
            }
            if (value instanceof class_7291) {
                class_7291 translatableOption = (class_7291)value;
                return translatableOption.method_42627();
            }
            return class_2561.method_30163((String)value.name());
        };
    }

    public EnumController(Option<T> option) {
        this(option, EnumController.getDefaultFormatter());
    }

    public EnumController(Option<T> option, Function<T, class_2561> valueFormatter) {
        this(option, valueFormatter, (Enum[])option.typeClass().getEnumConstants());
    }

    public EnumController(Option<T> option, Function<T, class_2561> valueFormatter, T[] availableValues) {
        this.option = option;
        this.valueFormatter = valueFormatter;
        this.availableValues = availableValues;
    }

    @Override
    public Option<T> option() {
        return this.option;
    }

    @Override
    public class_2561 formatValue() {
        return this.valueFormatter.apply((Enum)this.option().pendingValue());
    }

    @Override
    public AbstractWidget provideWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
        return new EnumControllerElement(this, screen, widgetDimension, this.availableValues);
    }

    public static class EnumControllerElement<T extends Enum<T>>
    extends ControllerWidget<EnumController<T>> {
        private final T[] values;

        public EnumControllerElement(EnumController<T> control, YACLScreen screen, Dimension<Integer> dim, T[] values) {
            super(control, screen, dim);
            this.values = values;
        }

        public void cycleValue(int increment) {
            int targetIdx = ((Enum)((EnumController)this.control).option().pendingValue()).ordinal() + increment;
            if (targetIdx >= this.values.length) {
                targetIdx -= this.values.length;
            } else if (targetIdx < 0) {
                targetIdx += this.values.length;
            }
            ((EnumController)this.control).option().requestSet(this.values[targetIdx]);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (!this.method_25405(mouseX, mouseY) || button != 0 && button != 1 || !this.isAvailable()) {
                return false;
            }
            this.playDownSound();
            this.cycleValue(button == 1 || class_437.method_25442() || class_437.method_25441() ? -1 : 1);
            return true;
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (!this.focused) {
                return false;
            }
            switch (keyCode) {
                case 263: 
                case 264: {
                    this.cycleValue(-1);
                    break;
                }
                case 262: 
                case 265: {
                    this.cycleValue(1);
                    break;
                }
                case 32: 
                case 257: 
                case 335: {
                    this.cycleValue(class_437.method_25441() || class_437.method_25442() ? -1 : 1);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        @Override
        protected int getHoveredControlWidth() {
            return this.getUnhoveredControlWidth();
        }
    }
}

