/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3324;
import su.plo.voice.server.VoiceServer;
import su.plo.voice.server.commands.CommandManager;
import su.plo.voice.server.config.Configuration;

public class VoicePermissions {
    private static RequiredArgumentBuilder<class_2168, String> permissions() {
        return class_2170.method_9244((String)"permission", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            Configuration section = VoiceServer.getInstance().getConfig().getSection("permissions");
            return class_2172.method_9265(new ArrayList<String>(section.getKeys()), (SuggestionsBuilder)builder);
        });
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"vperms").requires(source -> CommandManager.requiresPermission(source, "voice.permissions"))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).suggests((commandContext, suggestionsBuilder) -> {
            class_3324 playerList = ((class_2168)commandContext.getSource()).method_9211().method_3760();
            return class_2172.method_9264(playerList.method_14571().stream().map(serverPlayer -> serverPlayer.method_7334().getName()), (SuggestionsBuilder)suggestionsBuilder);
        }).then(class_2170.method_9247((String)"set").then(((RequiredArgumentBuilder)VoicePermissions.permissions().executes(ctx -> {
            class_2191.method_9330((CommandContext)ctx, (String)"targets").forEach(gameProfile -> VoicePermissions.set((CommandContext<class_2168>)ctx, gameProfile, StringArgumentType.getString((CommandContext)ctx, (String)"permission"), true));
            return 1;
        })).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            class_2191.method_9330((CommandContext)ctx, (String)"targets").forEach(gameProfile -> VoicePermissions.set((CommandContext<class_2168>)ctx, gameProfile, StringArgumentType.getString((CommandContext)ctx, (String)"permission"), BoolArgumentType.getBool((CommandContext)ctx, (String)"value")));
            return 1;
        }))))).then(class_2170.method_9247((String)"unset").then(VoicePermissions.permissions().executes(ctx -> {
            class_2191.method_9330((CommandContext)ctx, (String)"targets").forEach(gameProfile -> VoicePermissions.unset((CommandContext<class_2168>)ctx, gameProfile, StringArgumentType.getString((CommandContext)ctx, (String)"permission")));
            return 1;
        })))).then(class_2170.method_9247((String)"check").then(VoicePermissions.permissions().executes(ctx -> {
            class_2191.method_9330((CommandContext)ctx, (String)"targets").forEach(gameProfile -> VoicePermissions.check((CommandContext<class_2168>)ctx, gameProfile, StringArgumentType.getString((CommandContext)ctx, (String)"permission")));
            return 1;
        })))));
    }

    private static void check(CommandContext<class_2168> ctx, GameProfile profile, String permission) {
        Configuration section = VoiceServer.getInstance().getConfig().getSection("permissions");
        if (!section.getKeys().contains(permission)) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)VoiceServer.getInstance().getMessagePrefix("permissions.not_found")));
            return;
        }
        ((class_2168)ctx.getSource()).method_9226((class_2561)class_2561.method_43470((String)VoiceServer.getInstance().getMessagePrefix("permissions.check").replace("{player}", profile.getName()).replace("{permission}", permission).replace("{value}", String.valueOf(VoiceServer.getPlayerManager().hasPermission(profile.getId(), permission)))), false);
    }

    private static void set(CommandContext<class_2168> ctx, GameProfile profile, String permission, boolean value) {
        Configuration section = VoiceServer.getInstance().getConfig().getSection("permissions");
        if (!section.getKeys().contains(permission)) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)VoiceServer.getInstance().getMessagePrefix("permissions.not_found")));
            return;
        }
        if (VoiceServer.getPlayerManager().hasPermission(profile.getId(), permission) == value) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)VoiceServer.getInstance().getMessagePrefix("permissions.already").replace("{player}", profile.getName()).replace("{permission}", permission).replace("{value}", String.valueOf(value))));
            return;
        }
        VoiceServer.getPlayerManager().setPermission(profile.getId(), permission, value);
        ((class_2168)ctx.getSource()).method_9226((class_2561)class_2561.method_43470((String)VoiceServer.getInstance().getMessagePrefix("permissions.set").replace("{player}", profile.getName()).replace("{permission}", permission).replace("{value}", String.valueOf(value))), false);
    }

    private static void unset(CommandContext<class_2168> ctx, GameProfile profile, String permission) {
        Configuration section = VoiceServer.getInstance().getConfig().getSection("permissions");
        if (!section.getKeys().contains(permission)) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)VoiceServer.getInstance().getMessagePrefix("permissions.not_found")));
            return;
        }
        Map<String, Boolean> perms = VoiceServer.getPlayerManager().getPermissions().get(profile.getId());
        if (perms == null || !perms.containsKey(permission)) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)VoiceServer.getInstance().getMessagePrefix("permissions.no_permission").replace("{player}", profile.getName()).replace("{permission}", permission)));
            return;
        }
        VoiceServer.getPlayerManager().unSetPermission(profile.getId(), permission);
        ((class_2168)ctx.getSource()).method_9226((class_2561)class_2561.method_43470((String)VoiceServer.getInstance().getMessagePrefix("permissions.unset").replace("{player}", profile.getName()).replace("{permission}", permission)), false);
    }
}

