/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_3222;
import su.plo.voice.common.packets.tcp.ClientUnmutedPacket;
import su.plo.voice.server.VoiceServer;
import su.plo.voice.server.config.Configuration;
import su.plo.voice.server.config.ServerMuted;
import su.plo.voice.server.network.ServerNetworkHandler;

public class PlayerManager {
    private final ConcurrentHashMap<UUID, Map<String, Boolean>> permissions = new ConcurrentHashMap();

    public synchronized boolean hasPermission(UUID player, String permission) {
        Map<String, Boolean> perms = this.permissions.get(player);
        if (perms != null) {
            return perms.getOrDefault(permission, this.hasDefaultPermission(player, permission));
        }
        return this.hasDefaultPermission(player, permission);
    }

    public synchronized void setPermission(UUID uuid, String permission, boolean value) {
        if (this.hasDefaultPermission(uuid, permission) == value) {
            this.unSetPermission(uuid, permission);
            return;
        }
        if (this.permissions.containsKey(uuid)) {
            Map<String, Boolean> perms = this.permissions.get(uuid);
            perms.put(permission, value);
        } else {
            HashMap<String, Boolean> perms = new HashMap<String, Boolean>();
            perms.put(permission, value);
            this.permissions.put(uuid, perms);
        }
        VoiceServer.saveData(true);
    }

    public synchronized void unSetPermission(UUID uuid, String permission) {
        if (this.permissions.containsKey(uuid)) {
            Map<String, Boolean> perms = this.permissions.get(uuid);
            perms.remove(permission);
        }
        VoiceServer.saveData(true);
    }

    public boolean hasDefaultPermission(UUID player, String permission) {
        String defaultPermission = this.getDefaultPermission(permission);
        if (defaultPermission.equals("op")) {
            return PlayerManager.isOp(player);
        }
        return true;
    }

    private String getDefaultPermission(String permission) {
        Configuration section = VoiceServer.getInstance().getConfig().getSection("permissions");
        Object obj = section.getSelf().get(permission);
        if (obj == null) {
            return "";
        }
        return obj instanceof String ? (String)obj : "";
    }

    public boolean isMuted(UUID uuid) {
        ServerMuted muted = VoiceServer.getMuted().get(uuid);
        if (muted != null) {
            if (muted.getTo() == 0L || muted.getTo() > System.currentTimeMillis()) {
                return true;
            }
            VoiceServer.getMuted().remove(uuid);
            ServerNetworkHandler.sendToClients(new ClientUnmutedPacket(uuid), null);
        }
        return false;
    }

    public static class_3222 getByUUID(UUID uuid) {
        return VoiceServer.getServer().method_3760().method_14602(uuid);
    }

    public static boolean isOp(UUID player) {
        return VoiceServer.getServer().method_3760().method_14569((GameProfile)VoiceServer.getServer().method_3793().method_14512(player).get());
    }

    public static boolean isOp(class_3222 player) {
        return VoiceServer.getServer().method_3760().method_14569(player.method_7334());
    }

    public ConcurrentHashMap<UUID, Map<String, Boolean>> getPermissions() {
        return this.permissions;
    }
}

