/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.common.packets.tcp;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.UUID;
import su.plo.voice.common.entities.MutedEntity;
import su.plo.voice.common.packets.Packet;

public class ClientConnectedPacket
implements Packet {
    private UUID client;
    private MutedEntity muted;

    public ClientConnectedPacket() {
    }

    public ClientConnectedPacket(UUID client, MutedEntity muted) {
        this.client = client;
        this.muted = muted;
    }

    public UUID getClient() {
        return this.client;
    }

    public MutedEntity getMuted() {
        return this.muted;
    }

    @Override
    public void write(ByteArrayDataOutput buf) throws IOException {
        buf.writeUTF(this.client.toString());
        buf.writeByte(this.muted == null ? 0 : 1);
        if (this.muted != null) {
            buf.writeUTF(this.muted.uuid.toString());
            buf.writeLong(this.muted.to.longValue());
        }
    }

    @Override
    public void read(ByteArrayDataInput buf) throws IOException {
        this.client = UUID.fromString(buf.readUTF());
        if (buf.readByte() == 1) {
            this.muted = new MutedEntity(UUID.fromString(buf.readUTF()), buf.readLong());
        }
    }
}

