/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.sound.openal;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1657;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.lwjgl.openal.EXTThreadLocalContext;
import su.plo.voice.client.VoiceClient;
import su.plo.voice.client.gui.VoiceSettingsScreen;
import su.plo.voice.client.sound.AbstractSoundQueue;
import su.plo.voice.client.sound.Occlusion;
import su.plo.voice.client.sound.openal.AlUtil;
import su.plo.voice.common.packets.udp.VoiceServerPacket;

public class OpenALPlayerQueue
extends AbstractSoundQueue {
    public OpenALPlayerQueue(UUID from) {
        super(from);
        VoiceClient.getSoundEngine().runInContext(() -> {
            this.source = VoiceClient.getSoundEngine().createSource();
            if (this.source == null) {
                this.stopped = true;
                return;
            }
            this.source.setPitch(1.0f);
            this.source.setLooping(false);
            this.source.setRelative(false);
            if (((Boolean)VoiceClient.getClientConfig().directionalSources.get()).booleanValue()) {
                this.source.setAngle(((Integer)VoiceClient.getClientConfig().directionalSourcesAngle.get()).intValue());
            }
            AlUtil.checkErrors("Create custom source");
            this.start();
        });
    }

    @Override
    public void run() {
        EXTThreadLocalContext.alcSetThreadContext((long)VoiceClient.getSoundEngine().getContextPointer());
        while (!this.stopped) {
            int packetsToCompensate;
            int fadeDistance;
            class_1657 player;
            VoiceSettingsScreen screen;
            class_437 class_4372;
            VoiceServerPacket packet = (VoiceServerPacket)this.queue.poll(10L, TimeUnit.MILLISECONDS);
            if (packet == null) continue;
            this.lastPacketTime = System.currentTimeMillis();
            if (packet.getData().length == 0) {
                this.opusDecoder.reset();
                this.lastSequenceNumber = -1L;
                this.lastOcclusion = -1.0;
                continue;
            }
            if (((Boolean)VoiceClient.getClientConfig().speakerMuted.get()).booleanValue() || (Double)VoiceClient.getClientConfig().voiceVolume.get() == 0.0 || this.lastSequenceNumber >= 0L && packet.getSequenceNumber() <= this.lastSequenceNumber || (class_4372 = this.minecraft.field_1755) instanceof VoiceSettingsScreen && (screen = (VoiceSettingsScreen)class_4372).getSource() != null || (player = this.minecraft.field_1687.method_18470(this.from)) == null) continue;
            class_746 clientPlayer = this.minecraft.field_1724;
            boolean isPriority = packet.getDistance() > VoiceClient.getServerConfig().getMaxDistance();
            float distance = (float)player.method_19538().method_1022(clientPlayer.method_19538());
            float percentage = (float)VoiceClient.getClientConfig().getPlayerVolume(player.method_5667(), isPriority);
            if (percentage == 0.0f) continue;
            short maxDistance = packet.getDistance();
            if (distance > (float)maxDistance) {
                this.lastSequenceNumber = -1L;
                this.lastOcclusion = -1.0;
                continue;
            }
            int n = fadeDistance = isPriority ? maxDistance / VoiceClient.getServerConfig().getPriorityFadeDivisor() : maxDistance / VoiceClient.getServerConfig().getFadeDivisor();
            if (!VoiceClient.getSoundEngine().isSoundPhysics() && ((Boolean)VoiceClient.getClientConfig().occlusion.get()).booleanValue()) {
                double occlusion = Occlusion.getOccludedPercent(player.field_6002, (class_1657)clientPlayer, player.method_19538());
                if (this.lastOcclusion >= 0.0) {
                    this.lastOcclusion = occlusion > this.lastOcclusion ? Math.max(this.lastOcclusion + 0.05, 0.0) : Math.max(this.lastOcclusion - 0.05, occlusion);
                    occlusion = this.lastOcclusion;
                }
                percentage *= (float)(1.0 - occlusion);
                if (this.lastOcclusion == -1.0) {
                    this.lastOcclusion = occlusion;
                }
            }
            this.source.setPosition(player.method_19538());
            this.source.setDirection(player.method_5720());
            this.source.setVolume(percentage);
            this.source.setFadeDistance(fadeDistance);
            this.source.setMaxDistance(maxDistance, 0.95f);
            if (this.lastSequenceNumber >= 0L && (packetsToCompensate = (int)(packet.getSequenceNumber() - (this.lastSequenceNumber + 1L))) <= 4) {
                for (int i = 0; i < packetsToCompensate; ++i) {
                    this.source.write(this.opusDecoder.decode(null));
                }
            }
            byte[] decoded = this.opusDecoder.decode(packet.getData());
            if (((Boolean)VoiceClient.getClientConfig().compressor.get()).booleanValue()) {
                decoded = this.compressor.compress(decoded);
            }
            this.source.write(decoded);
            this.lastSequenceNumber = packet.getSequenceNumber();
        }
        if (this.source != null) {
            this.source.close();
        }
        EXTThreadLocalContext.alcSetThreadContext((long)0L);
    }
}

