/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.socket;

import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_310;
import net.minecraft.class_437;
import su.plo.voice.client.VoiceClient;
import su.plo.voice.client.gui.VoiceNotAvailableScreen;
import su.plo.voice.client.gui.VoiceSettingsScreen;
import su.plo.voice.client.socket.SocketClientUDP;
import su.plo.voice.client.sound.AbstractSoundQueue;
import su.plo.voice.client.sound.openal.OpenALPlayerQueue;
import su.plo.voice.common.packets.Packet;
import su.plo.voice.common.packets.udp.AuthPacketAck;
import su.plo.voice.common.packets.udp.PacketUDP;
import su.plo.voice.common.packets.udp.PingPacket;
import su.plo.voice.common.packets.udp.VoiceEndServerPacket;
import su.plo.voice.common.packets.udp.VoiceServerPacket;

public class SocketClientUDPQueue
extends Thread {
    private static final class_310 client = class_310.method_1551();
    private final SocketClientUDP socket;
    public ConcurrentLinkedQueue<PacketUDP> queue = new ConcurrentLinkedQueue();
    public static final Map<UUID, AbstractSoundQueue> audioChannels = new ConcurrentHashMap<UUID, AbstractSoundQueue>();
    public static final ConcurrentHashMap<UUID, Boolean> talking = new ConcurrentHashMap();

    public SocketClientUDPQueue(SocketClientUDP socket) {
        this.socket = socket;
    }

    public static void closeAll() {
        audioChannels.values().forEach(AbstractSoundQueue::closeAndKill);
        audioChannels.clear();
        talking.clear();
    }

    private void queuePacket(VoiceServerPacket packet, UUID uuid) {
        AbstractSoundQueue ch = audioChannels.get(uuid);
        if (ch == null || ch.isClosed()) {
            VoiceClient.getServerConfig().getClients().add(uuid);
            if (packet instanceof VoiceServerPacket) {
                ch = new OpenALPlayerQueue(uuid);
                ch.addQueue(packet);
            }
            audioChannels.put(uuid, ch);
        } else {
            ch.addQueue(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.socket.isClosed()) {
            if (!this.queue.isEmpty()) {
                PacketUDP message = this.queue.poll();
                if (message.getPacket() instanceof AuthPacketAck) {
                    if (this.socket.authorized) continue;
                    VoiceClient.LOGGER.info("Connected to UDP");
                    this.socket.authorized = true;
                    if (!(SocketClientUDPQueue.client.field_1755 instanceof VoiceNotAvailableScreen)) continue;
                    client.execute(() -> client.method_1507((class_437)new VoiceSettingsScreen()));
                    continue;
                }
                Packet packet = message.getPacket();
                if (packet instanceof VoiceServerPacket) {
                    VoiceServerPacket packet2 = (VoiceServerPacket)packet;
                    if (VoiceClient.getClientConfig().isMuted(packet2.getFrom()) || ((Boolean)VoiceClient.getClientConfig().speakerMuted.get()).booleanValue()) continue;
                    talking.put(packet2.getFrom(), packet2.getDistance() > VoiceClient.getServerConfig().getMaxDistance());
                    this.queuePacket(packet2, packet2.getFrom());
                    continue;
                }
                packet = message.getPacket();
                if (packet instanceof VoiceEndServerPacket) {
                    VoiceEndServerPacket packet3 = (VoiceEndServerPacket)packet;
                    if (VoiceClient.getClientConfig().isMuted(packet3.getFrom())) continue;
                    talking.remove(packet3.getFrom());
                    AbstractSoundQueue ch = audioChannels.get(packet3.getFrom());
                    if (ch == null) continue;
                    ch.addQueue(new VoiceServerPacket(new byte[]{}, packet3.getFrom(), ch.lastSequenceNumber + 1L, VoiceClient.isSpeakingPriority() ? VoiceClient.getServerConfig().getPriorityDistance() : VoiceClient.getServerConfig().getDistance()));
                    continue;
                }
                if (!(message.getPacket() instanceof PingPacket)) continue;
                this.socket.keepAlive = System.currentTimeMillis();
                this.socket.ping.timedOut = false;
                try {
                    this.socket.send(new PingPacket());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            SocketClientUDPQueue socketClientUDPQueue = this;
            synchronized (socketClientUDPQueue) {
                try {
                    this.wait();
                }
                catch (InterruptedException ignored) {
                    break;
                }
            }
        }
    }
}

