/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.render;

import net.minecraft.class_1159;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import su.plo.voice.client.VoiceClient;
import su.plo.voice.client.gui.PlayerVolumeHandler;
import su.plo.voice.client.socket.SocketClientUDPQueue;
import su.plo.voice.common.entities.MutedEntity;

public class EntityIconRenderer {
    private final class_310 client = class_310.method_1551();
    private static final EntityIconRenderer instance = new EntityIconRenderer();

    private EntityIconRenderer() {
    }

    public void entityRender(class_1657 player, double distance, class_4587 matrices, boolean hasLabel, class_4597 vertexConsumers, int light) {
        if (this.isIconHidden(player)) {
            return;
        }
        if (VoiceClient.getServerConfig().getClients().contains(player.method_5667())) {
            if (VoiceClient.getClientConfig().isMuted(player.method_5667())) {
                this.renderIcon(80.0f, 0.0f, player, distance, matrices, hasLabel, vertexConsumers, light);
            } else if (VoiceClient.getServerConfig().getMuted().containsKey(player.method_5667())) {
                MutedEntity muted = VoiceClient.getServerConfig().getMuted().get(player.method_5667());
                if (muted.to == 0L || muted.to > System.currentTimeMillis()) {
                    this.renderIcon(80.0f, 0.0f, player, distance, matrices, hasLabel, vertexConsumers, light);
                } else {
                    VoiceClient.getServerConfig().getMuted().remove(muted.uuid);
                }
            } else {
                Boolean isTalking = SocketClientUDPQueue.talking.get(player.method_5667());
                if (isTalking != null) {
                    if (isTalking.booleanValue()) {
                        this.renderIcon(96.0f, 0.0f, player, distance, matrices, hasLabel, vertexConsumers, light);
                    } else {
                        this.renderIcon(64.0f, 0.0f, player, distance, matrices, hasLabel, vertexConsumers, light);
                    }
                } else if (PlayerVolumeHandler.isShow(player)) {
                    this.renderPercent(player, distance, matrices, hasLabel, vertexConsumers, light);
                }
            }
        } else {
            this.renderIcon(112.0f, 0.0f, player, distance, matrices, hasLabel, vertexConsumers, light);
        }
    }

    private boolean isIconHidden(class_1657 player) {
        if ((Integer)VoiceClient.getClientConfig().showIcons.get() == 2) {
            return true;
        }
        if (player.method_5667().equals(this.client.field_1724.method_5667())) {
            return true;
        }
        if (!this.client.field_1724.field_3944.method_31363().contains(player.method_5667())) {
            return true;
        }
        return player.method_5756((class_1657)this.client.field_1724) || this.client.field_1690.field_1842 && (Integer)VoiceClient.getClientConfig().showIcons.get() == 0;
    }

    private void renderPercent(class_1657 player, double distance, class_4587 matrices, boolean hasLabel, class_4597 vertexConsumers, int light) {
        double yOffset = 0.5;
        if (hasLabel) {
            yOffset += 0.3;
            class_269 scoreboard = player.method_7327();
            class_266 scoreboardObjective = scoreboard.method_1189(2);
            if (scoreboardObjective != null && distance < 100.0) {
                yOffset += 0.3;
            }
        }
        matrices.method_22903();
        matrices.method_22904(0.0, (double)player.method_17682() + yOffset, 0.0);
        matrices.method_22907(this.client.method_1561().method_24197());
        matrices.method_22905(-0.025f, -0.025f, 0.025f);
        matrices.method_22904(0.0, -1.0, 0.0);
        class_1159 matrix4f = matrices.method_23760().method_23761();
        boolean bl = !player.method_21752();
        float g = this.client.field_1690.method_19343(0.25f);
        int j = (int)(g * 255.0f) << 24;
        class_327 textRenderer = this.client.field_1772;
        class_5250 text = class_2561.method_43470((String)((int)Math.round(VoiceClient.getClientConfig().getPlayerVolumes().getOrDefault(player.method_5667(), 1.0) * 100.0) + "%"));
        float h = -textRenderer.method_27525((class_5348)text) / 2;
        textRenderer.method_30882((class_2561)text, h, 0.0f, 0x20FFFFFF, false, matrix4f, vertexConsumers, bl, j, light);
        if (bl) {
            textRenderer.method_30882((class_2561)text, h, 0.0f, -1, false, matrix4f, vertexConsumers, false, 0, light);
        }
        matrices.method_22909();
    }

    private void renderIcon(float u, float v, class_1657 player, double distance, class_4587 matrices, boolean hasLabel, class_4597 vertexConsumers, int light) {
        double yOffset = 0.5;
        if (PlayerVolumeHandler.isShow(player)) {
            this.renderPercent(player, distance, matrices, hasLabel, vertexConsumers, light);
            yOffset += 0.3;
        }
        if (hasLabel) {
            yOffset += 0.3;
            class_269 scoreboard = player.method_7327();
            class_266 scoreboardObjective = scoreboard.method_1189(2);
            if (scoreboardObjective != null && distance < 100.0) {
                yOffset += 0.3;
            }
        }
        matrices.method_22903();
        matrices.method_22904(0.0, (double)player.method_17682() + yOffset, 0.0);
        matrices.method_22907(this.client.method_1561().method_24197());
        matrices.method_22905(-0.025f, -0.025f, 0.025f);
        matrices.method_22904(0.0, -1.0, 0.0);
        float offset = -5.0f;
        class_4588 builder = vertexConsumers.getBuffer(class_1921.method_23028((class_2960)VoiceClient.ICONS));
        float u0 = u / 256.0f;
        float u1 = (u + 16.0f) / 256.0f;
        float v0 = v / 256.0f;
        float v1 = (v + 16.0f) / 256.0f;
        if (player.method_21752()) {
            this.vertex(builder, matrices, offset, 10.0f, 0.0f, u0, v1, 40, light);
            this.vertex(builder, matrices, offset + 10.0f, 10.0f, 0.0f, u1, v1, 40, light);
            this.vertex(builder, matrices, offset + 10.0f, 0.0f, 0.0f, u1, v0, 40, light);
            this.vertex(builder, matrices, offset, 0.0f, 0.0f, u0, v0, 40, light);
        } else {
            this.vertex(builder, matrices, offset, 10.0f, 0.0f, u0, v1, 255, light);
            this.vertex(builder, matrices, offset + 10.0f, 10.0f, 0.0f, u1, v1, 255, light);
            this.vertex(builder, matrices, offset + 10.0f, 0.0f, 0.0f, u1, v0, 255, light);
            this.vertex(builder, matrices, offset, 0.0f, 0.0f, u0, v0, 255, light);
            class_4588 builderSeeThrough = vertexConsumers.getBuffer(class_1921.method_23030((class_2960)VoiceClient.ICONS));
            this.vertex(builderSeeThrough, matrices, offset, 10.0f, 0.0f, u0, v1, 40, light);
            this.vertex(builderSeeThrough, matrices, offset + 10.0f, 10.0f, 0.0f, u1, v1, 40, light);
            this.vertex(builderSeeThrough, matrices, offset + 10.0f, 0.0f, 0.0f, u1, v0, 40, light);
            this.vertex(builderSeeThrough, matrices, offset, 0.0f, 0.0f, u0, v0, 40, light);
        }
        matrices.method_22909();
    }

    private void vertex(class_4588 builder, class_4587 matrices, float x, float y, float z, float u, float v, int alpha, int light) {
        class_4587.class_4665 entry = matrices.method_23760();
        class_1159 modelViewMatrix = entry.method_23761();
        builder.method_22918(modelViewMatrix, x, y, z);
        builder.method_1336(255, 255, 255, alpha);
        builder.method_22913(u, v);
        builder.method_22922(class_4608.field_21444);
        builder.method_22916(light);
        builder.method_22914(0.0f, 0.0f, -1.0f);
        builder.method_1344();
    }

    public static EntityIconRenderer getInstance() {
        return instance;
    }
}

