/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.config.entries;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import su.plo.voice.client.config.entries.ConfigEntry;

public class IntegerConfigEntry
extends ConfigEntry<Integer>
implements JsonDeserializer<IntegerConfigEntry>,
JsonSerializer<IntegerConfigEntry> {
    private int min;
    private int max;

    public IntegerConfigEntry() {
    }

    public IntegerConfigEntry(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public void increment() {
        this.set(((Integer)this.get() + 1) % (this.getMax() + 1));
    }

    public void decrement() {
        this.set((Integer)this.get() - 1 < this.getMin() ? this.getMax() : (Integer)this.get() - 1);
    }

    @Override
    public void set(Integer value) {
        if (this.min != this.max && this.min > 0 && this.max > 0) {
            super.set(Math.max(Math.min(value, this.max), this.min));
        } else {
            super.set(value);
        }
    }

    public void setDefault(int value, int min, int max) {
        super.setDefault(value);
        this.min = min;
        this.max = max;
    }

    public IntegerConfigEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        IntegerConfigEntry entry = new IntegerConfigEntry(0, 0);
        try {
            entry.set(json.getAsInt());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return entry;
    }

    public JsonElement serialize(IntegerConfigEntry src, Type typeOfSrc, JsonSerializationContext context) {
        return src.get() == null ? null : new JsonPrimitive((Number)src.get());
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }
}

