/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.config.entries;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import su.plo.voice.client.config.entries.ConfigEntry;

public class DoubleConfigEntry
extends ConfigEntry<Double>
implements JsonDeserializer<DoubleConfigEntry>,
JsonSerializer<DoubleConfigEntry> {
    private double min;
    private double max;

    public DoubleConfigEntry(double min, double max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public void set(Double value) {
        if (this.min != this.max && this.min > 0.0) {
            super.set(Math.max(Math.min(value, this.max), this.min));
        } else {
            super.set(value);
        }
    }

    public void setDefault(double value, double min, double max) {
        super.setDefault(value);
        this.min = min;
        this.max = max;
    }

    public DoubleConfigEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        DoubleConfigEntry entry = new DoubleConfigEntry(0.0, 0.0);
        try {
            entry.set(json.getAsDouble());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return entry;
    }

    public JsonElement serialize(DoubleConfigEntry src, Type typeOfSrc, JsonSerializationContext context) {
        return src.get() == null ? null : new JsonPrimitive((Number)src.get());
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }
}

