/*
 * Decompiled with CFR 0.152.
 */
package dynamicfps;

import com.moandjiezana.toml.Toml;
import com.moandjiezana.toml.TomlWriter;
import java.io.File;
import java.io.IOException;
import net.fabricmc.loader.api.FabricLoader;

public final class DynamicFPSConfig {
    private transient File file;
    public boolean reduceFPSWhenUnfocused = true;
    public int unfocusedFPS = 1;
    public boolean restoreFPSWhenHovered = true;
    public float unfocusedVolumeMultiplier = 0.25f;
    public float hiddenVolumeMultiplier = 0.0f;
    public boolean runGCOnUnfocus = false;

    private DynamicFPSConfig() {
    }

    public static DynamicFPSConfig load() {
        DynamicFPSConfig config;
        File file = new File(FabricLoader.getInstance().getConfigDir().toString(), "dynamicfps.toml");
        if (file.exists()) {
            Toml configTOML = new Toml().read(file);
            config = (DynamicFPSConfig)configTOML.to(DynamicFPSConfig.class);
            config.file = file;
        } else {
            config = new DynamicFPSConfig();
            config.file = file;
            config.save();
        }
        return config;
    }

    public void save() {
        TomlWriter writer = new TomlWriter();
        try {
            writer.write((Object)this, this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

