/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camerautils.configbuilder;

import de.maxhenkel.camerautils.configbuilder.Config;
import de.maxhenkel.camerautils.configbuilder.ConfigEntry;
import de.maxhenkel.camerautils.configbuilder.PropertyConfig;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ConfigBuilder {
    protected PropertyConfig config;
    protected List<ConfigEntryImpl<?>> entries;

    private ConfigBuilder(PropertyConfig config) {
        this.config = config;
        this.entries = new ArrayList();
    }

    static ConfigBuilder buildInternal(Path path) {
        return new ConfigBuilder(new PropertyConfig(path));
    }

    public static <T> T build(Path path, Function<ConfigBuilder, T> builderConsumer) {
        return ConfigBuilder.build(path, false, builderConsumer);
    }

    public static <T> T build(Path path, boolean removeUnused, Function<ConfigBuilder, T> builderConsumer) {
        ConfigBuilder builder = ConfigBuilder.buildInternal(path);
        T config = builderConsumer.apply(builder);
        if (removeUnused) {
            builder.removeUnused();
        }
        builder.config.save();
        return config;
    }

    void removeUnused() {
        List existingKeys = this.entries.stream().map(configEntry -> configEntry.key).collect(Collectors.toList());
        List toRemove = this.config.getProperties().stringPropertyNames().stream().filter(s -> !existingKeys.contains(s)).collect(Collectors.toList());
        for (String key : toRemove) {
            this.config.getProperties().remove(key);
        }
    }

    void reloadFromDisk() {
        this.config.reload();
        this.entries.forEach(ConfigEntryImpl::loadOrDefault);
    }

    public ConfigEntry<Boolean> booleanEntry(String key, boolean def) {
        BooleanConfigEntry entry = new BooleanConfigEntry(this.config);
        entry.key = key;
        entry.def = def;
        entry.loadOrDefault();
        this.entries.add(entry);
        return entry;
    }

    public ConfigEntry<Integer> integerEntry(String key, int def, int min, int max) {
        IntegerConfigEntry entry = new IntegerConfigEntry(this.config, min, max);
        entry.key = key;
        entry.def = def;
        entry.loadOrDefault();
        this.entries.add(entry);
        return entry;
    }

    public ConfigEntry<Double> doubleEntry(String key, double def, double min, double max) {
        DoubleConfigEntry entry = new DoubleConfigEntry(this.config, min, max);
        entry.key = key;
        entry.def = def;
        entry.loadOrDefault();
        this.entries.add(entry);
        return entry;
    }

    public ConfigEntry<String> stringEntry(String key, String def) {
        StringConfigEntry entry = new StringConfigEntry(this.config);
        entry.key = key;
        entry.def = def;
        entry.loadOrDefault();
        this.entries.add(entry);
        return entry;
    }

    public ConfigEntry<List<Integer>> integerListEntry(String key, List<Integer> def) {
        IntegerListConfigEntry entry = new IntegerListConfigEntry(this.config);
        entry.key = key;
        entry.def = def;
        entry.loadOrDefault();
        this.entries.add(entry);
        return entry;
    }

    public <T extends Enum<T>> ConfigEntry<T> enumEntry(String key, T def) {
        EnumConfigEntry entry = new EnumConfigEntry(this.config, def.getClass());
        entry.key = key;
        entry.def = def;
        entry.loadOrDefault();
        this.entries.add(entry);
        return entry;
    }

    public static class IntegerListConfigEntry
    extends ConfigEntryImpl<List<Integer>> {
        private IntegerListConfigEntry(PropertyConfig config) {
            super(config);
        }

        @Override
        @Nullable
        public List<Integer> deserialize(String str) {
            String[] split;
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (String n : split = str.split(",")) {
                try {
                    list.add(Integer.parseInt(n));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return list;
        }

        @Override
        public String serialize(List<Integer> val) {
            return val.stream().map(String::valueOf).collect(Collectors.joining(","));
        }
    }

    public static class EnumConfigEntry<T extends Enum>
    extends ConfigEntryImpl<Enum> {
        protected Class<T> enumClass;

        public EnumConfigEntry(PropertyConfig config, Class<T> enumClass) {
            super(config);
            this.enumClass = enumClass;
        }

        @Override
        @Nullable
        public Enum deserialize(String str) {
            try {
                return Enum.valueOf(this.enumClass, str);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public String serialize(Enum val) {
            return val.name();
        }
    }

    public static class StringConfigEntry
    extends ConfigEntryImpl<String> {
        private StringConfigEntry(PropertyConfig config) {
            super(config);
        }

        @Override
        @Nullable
        public String deserialize(String str) {
            return str;
        }

        @Override
        public String serialize(String val) {
            return val;
        }
    }

    public static class DoubleConfigEntry
    extends ConfigEntryImpl<Double> {
        private final double min;
        private final double max;

        public DoubleConfigEntry(PropertyConfig config, double min, double max) {
            super(config);
            this.min = min;
            this.max = max;
        }

        @Override
        @Nullable
        public Double deserialize(String str) {
            try {
                return Double.parseDouble(str);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        @Override
        protected Double fixValue(Double value) {
            return Math.max(Math.min(value, this.max), this.min);
        }

        @Override
        public String serialize(Double val) {
            return String.valueOf(val);
        }
    }

    public static class IntegerConfigEntry
    extends ConfigEntryImpl<Integer> {
        private final int min;
        private final int max;

        public IntegerConfigEntry(PropertyConfig config, int min, int max) {
            super(config);
            this.min = min;
            this.max = max;
        }

        @Override
        @Nullable
        public Integer deserialize(String str) {
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        @Override
        protected Integer fixValue(Integer value) {
            return Math.max(Math.min(value, this.max), this.min);
        }

        @Override
        public String serialize(Integer val) {
            return String.valueOf(val);
        }
    }

    public static class BooleanConfigEntry
    extends ConfigEntryImpl<Boolean> {
        private BooleanConfigEntry(PropertyConfig config) {
            super(config);
        }

        @Override
        @Nullable
        public Boolean deserialize(String str) {
            return Boolean.valueOf(str);
        }

        @Override
        public String serialize(Boolean val) {
            return String.valueOf(val);
        }
    }

    public static abstract class ConfigEntryImpl<T>
    implements ConfigEntry<T> {
        protected PropertyConfig config;
        protected String key;
        protected T value;
        protected T def;

        private ConfigEntryImpl(PropertyConfig config) {
            this.config = config;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public ConfigEntryImpl<T> set(T value) {
            if (this.value.equals(value)) {
                return this;
            }
            this.value = this.fixValue(value);
            String serialized = this.serialize(this.value);
            this.config.getProperties().setProperty(this.key, serialized);
            return this;
        }

        protected void loadOrDefault() {
            if (this.config.getProperties().containsKey(this.key)) {
                T val = this.deserialize(this.config.getProperties().getProperty(this.key));
                if (val == null) {
                    this.reset();
                } else {
                    this.value = this.fixValue(val);
                }
            } else {
                this.reset();
            }
        }

        @Override
        public ConfigEntry<T> reset() {
            this.value = this.def;
            this.config.getProperties().setProperty(this.key, this.serialize(this.def));
            return this;
        }

        @Override
        public ConfigEntry<T> save() {
            this.config.save();
            return this;
        }

        @Override
        public ConfigEntry<T> saveSync() {
            this.config.saveSync();
            return this;
        }

        @Nullable
        public abstract T deserialize(String var1);

        public abstract String serialize(T var1);

        protected T fixValue(T value) {
            return value;
        }

        @Override
        public T getDefault() {
            return this.def;
        }

        @Override
        public Config getConfig() {
            return this.config;
        }
    }
}

