/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.bobby;

import java.util.function.LongConsumer;
import net.minecraft.class_1923;

public class VisibleChunksTracker {
    private int centerX;
    private int centerZ;
    private int viewDistance;

    public void updateCenter(int centerX, int centerZ, LongConsumer unload, LongConsumer load) {
        this.update(centerX, centerZ, this.viewDistance, unload, load);
    }

    public void updateViewDistance(int viewDistance, LongConsumer unload, LongConsumer load) {
        this.update(this.centerX, this.centerZ, viewDistance, unload, load);
    }

    public void update(int newCenterX, int newCenterZ, int newViewDistance, LongConsumer unload, LongConsumer load) {
        int oldCenterX = this.centerX;
        int oldCenterZ = this.centerZ;
        int oldViewDistance = this.viewDistance;
        if (oldCenterX != newCenterX || oldCenterZ != newCenterZ || oldViewDistance != newViewDistance) {
            int z;
            int x;
            if (unload != null) {
                for (x = oldCenterX - oldViewDistance; x <= oldCenterX + oldViewDistance; ++x) {
                    boolean xOutsideNew = x < newCenterX - newViewDistance || x > newCenterX + newViewDistance;
                    for (z = oldCenterZ - oldViewDistance; z <= oldCenterZ + oldViewDistance; ++z) {
                        boolean zOutsideNew;
                        boolean bl = zOutsideNew = z < newCenterZ - newViewDistance || z > newCenterZ + newViewDistance;
                        if (!xOutsideNew && !zOutsideNew) continue;
                        unload.accept(class_1923.method_8331((int)x, (int)z));
                    }
                }
            }
            if (load != null) {
                for (x = newCenterX - newViewDistance; x <= newCenterX + newViewDistance; ++x) {
                    boolean xOutsideOld = x < oldCenterX - oldViewDistance || x > oldCenterX + oldViewDistance;
                    for (z = newCenterZ - newViewDistance; z <= newCenterZ + newViewDistance; ++z) {
                        boolean zOutsideOld;
                        boolean bl = zOutsideOld = z < oldCenterZ - oldViewDistance || z > oldCenterZ + oldViewDistance;
                        if (!xOutsideOld && !zOutsideOld) continue;
                        load.accept(class_1923.method_8331((int)x, (int)z));
                    }
                }
            }
            this.centerX = newCenterX;
            this.centerZ = newCenterZ;
            this.viewDistance = newViewDistance;
        }
    }

    public boolean isInViewDistance(int x, int z) {
        boolean xInside = x >= this.centerX - this.viewDistance && x <= this.centerX + this.viewDistance;
        boolean zInside = z >= this.centerZ - this.viewDistance && z <= this.centerZ + this.viewDistance;
        return xInside && zInside;
    }
}

